/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.components;

import java.util.ArrayList;
import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.conditionalexpectation.MonteCarloConditionalExpectationRegression;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.TermStructureMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.stochastic.RandomVariable;

public class ExposureEstimator
extends AbstractProductComponent {
    private static final long serialVersionUID = 2987369289230532162L;
    private final AbstractLIBORMonteCarloProduct underlying;

    public ExposureEstimator(AbstractLIBORMonteCarloProduct underlying) {
        this.underlying = underlying;
    }

    @Override
    public String getCurrency() {
        return this.underlying.getCurrency();
    }

    @Override
    public Set<String> queryUnderlyings() {
        if (this.underlying instanceof AbstractProductComponent) {
            return ((AbstractProductComponent)this.underlying).queryUnderlyings();
        }
        throw new IllegalArgumentException("Underlying cannot be queried for underlyings.");
    }

    @Override
    public RandomVariable getValue(double evaluationTime, TermStructureMonteCarloSimulationModel model) throws CalculationException {
        RandomVariable one = model.getRandomVariableForConstant(1.0);
        RandomVariable zero = model.getRandomVariableForConstant(0.0);
        RandomVariable values = this.underlying.getValue(evaluationTime, model);
        if (values.getFiltrationTime() > evaluationTime) {
            RandomVariable filterNaN = values.isNaN().sub(1.0).mult(-1.0);
            RandomVariable valuesFiltered = values.mult(filterNaN);
            double valuesMean = valuesFiltered.getAverage();
            double valuesStdDev = valuesFiltered.getStandardDeviation();
            double valuesFloor = valuesMean * (1.0 - Math.signum(valuesMean) * 1.0E-5) - 3.0 * valuesStdDev;
            double valuesCap = valuesMean * (1.0 + Math.signum(valuesMean) * 1.0E-5) + 3.0 * valuesStdDev;
            RandomVariable filter = values.sub(valuesFloor).choose(one, zero).mult(values.sub(valuesCap).mult(-1.0).choose(one, zero));
            filter = filter.mult(filterNaN);
            values = values.mult(filter);
            RandomVariable[] regressionBasisFunctions = this.getRegressionBasisFunctions(evaluationTime, (LIBORModelMonteCarloSimulationModel)model);
            RandomVariable[] filteredRegressionBasisFunctions = new RandomVariable[regressionBasisFunctions.length];
            for (int i = 0; i < regressionBasisFunctions.length; ++i) {
                filteredRegressionBasisFunctions[i] = regressionBasisFunctions[i].mult(filter);
            }
            MonteCarloConditionalExpectationRegression condExpEstimator = new MonteCarloConditionalExpectationRegression(filteredRegressionBasisFunctions, regressionBasisFunctions);
            values = condExpEstimator.getConditionalExpectation(values);
        }
        return values;
    }

    private RandomVariable[] getRegressionBasisFunctions(double evaluationTime, LIBORModelMonteCarloSimulationModel model) throws CalculationException {
        double periodLength3;
        double periodLength2;
        ArrayList<RandomVariable> basisFunctions = new ArrayList<RandomVariable>();
        RandomVariable basisFunction = model.getRandomVariableForConstant(1.0);
        basisFunctions.add(basisFunction);
        basisFunction = model.getRandomVariableForConstant(1.0);
        int liborPeriodIndex = model.getLiborPeriodIndex(evaluationTime);
        if (liborPeriodIndex < 0) {
            liborPeriodIndex = -liborPeriodIndex - 1;
        }
        int liborPeriodIndexEnd = liborPeriodIndex + 1;
        double periodLength1 = model.getLiborPeriod(liborPeriodIndexEnd) - model.getLiborPeriod(liborPeriodIndex);
        RandomVariable rate = model.getForwardRate(evaluationTime, model.getLiborPeriod(liborPeriodIndex), model.getLiborPeriod(liborPeriodIndexEnd));
        basisFunction = basisFunction.discount(rate, periodLength1);
        basisFunctions.add(basisFunction);
        basisFunction = basisFunction.discount(rate, periodLength1);
        basisFunctions.add(basisFunction);
        basisFunction = model.getRandomVariableForConstant(1.0);
        liborPeriodIndex = model.getLiborPeriodIndex(evaluationTime);
        if (liborPeriodIndex < 0) {
            liborPeriodIndex = -liborPeriodIndex - 1;
        }
        if ((periodLength2 = model.getLiborPeriod(liborPeriodIndexEnd = (liborPeriodIndex + model.getNumberOfLibors()) / 2) - model.getLiborPeriod(liborPeriodIndex)) != periodLength1) {
            rate = model.getForwardRate(evaluationTime, model.getLiborPeriod(liborPeriodIndex), model.getLiborPeriod(liborPeriodIndexEnd));
            basisFunction = basisFunction.discount(rate, periodLength2);
            basisFunctions.add(basisFunction);
            basisFunction = basisFunction.discount(rate, periodLength2);
            basisFunction = basisFunction.discount(rate, periodLength2);
        }
        basisFunction = model.getRandomVariableForConstant(1.0);
        liborPeriodIndex = model.getLiborPeriodIndex(evaluationTime);
        if (liborPeriodIndex < 0) {
            liborPeriodIndex = -liborPeriodIndex - 1;
        }
        if ((periodLength3 = model.getLiborPeriod(liborPeriodIndexEnd = model.getNumberOfLibors()) - model.getLiborPeriod(liborPeriodIndex)) != periodLength1 && periodLength3 != periodLength2) {
            rate = model.getForwardRate(evaluationTime, model.getLiborPeriod(liborPeriodIndex), model.getLiborPeriod(liborPeriodIndexEnd));
            basisFunction = basisFunction.discount(rate, periodLength3);
            basisFunctions.add(basisFunction);
            basisFunction = basisFunction.discount(rate, periodLength3);
        }
        return basisFunctions.toArray(new RandomVariable[0]);
    }
}

