/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.components;

import java.util.ArrayList;
import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.montecarlo.conditionalexpectation.MonteCarloConditionalExpectationRegression;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.TermStructureMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.stochastic.RandomVariable;

public class IndexedValue
extends AbstractProductComponent {
    private static final long serialVersionUID = -7268432817913776974L;
    private final double exerciseDate;
    private final AbstractProductComponent index;
    private final AbstractProductComponent underlying;

    public IndexedValue(double exerciseDate, AbstractProductComponent index, AbstractProductComponent underlying) {
        this.exerciseDate = exerciseDate;
        this.index = index;
        this.underlying = underlying;
    }

    @Override
    public String getCurrency() {
        return this.underlying.getCurrency();
    }

    @Override
    public Set<String> queryUnderlyings() {
        Set<String> underlyingNames = this.underlying.queryUnderlyings();
        Set<String> indexUnderylingNames = this.index.queryUnderlyings();
        if (underlyingNames == null && indexUnderylingNames == null) {
            return null;
        }
        if (underlyingNames != null && indexUnderylingNames == null) {
            return underlyingNames;
        }
        if (underlyingNames == null && indexUnderylingNames != null) {
            return indexUnderylingNames;
        }
        underlyingNames.addAll(indexUnderylingNames);
        return underlyingNames;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, TermStructureMonteCarloSimulationModel model) throws CalculationException {
        double evaluationTimeUnderlying = Math.max(evaluationTime, this.exerciseDate);
        RandomVariable underlyingValues = this.underlying.getValue(evaluationTimeUnderlying, model);
        RandomVariable indexValues = this.index.getValue(this.exerciseDate, model);
        if (indexValues.getFiltrationTime() > this.exerciseDate && this.exerciseDate > evaluationTime) {
            MonteCarloConditionalExpectationRegression condExpEstimator = new MonteCarloConditionalExpectationRegression(this.getRegressionBasisFunctions(this.exerciseDate, (LIBORModelMonteCarloSimulationModel)model));
            indexValues = condExpEstimator.getConditionalExpectation(indexValues);
        }
        underlyingValues = underlyingValues.mult(indexValues);
        if (evaluationTime != evaluationTimeUnderlying) {
            RandomVariable numeraireAtEval = model.getNumeraire(evaluationTime);
            RandomVariable numeraire = model.getNumeraire(evaluationTimeUnderlying);
            underlyingValues = underlyingValues.div(numeraire).mult(numeraireAtEval);
        }
        return underlyingValues;
    }

    private RandomVariable[] getRegressionBasisFunctions(double exerciseDate, LIBORModelMonteCarloSimulationModel model) throws CalculationException {
        ArrayList<RandomVariable> basisFunctions = new ArrayList<RandomVariable>();
        RandomVariable basisFunction = new RandomVariableFromDoubleArray(exerciseDate, 1.0);
        basisFunctions.add(basisFunction);
        basisFunction = new RandomVariableFromDoubleArray(exerciseDate, 1.0);
        int liborPeriodIndex = model.getLiborPeriodIndex(exerciseDate);
        int liborPeriodIndexEnd = liborPeriodIndex + 1;
        double periodLength = model.getLiborPeriod(liborPeriodIndexEnd) - model.getLiborPeriod(liborPeriodIndex);
        RandomVariable rate = model.getForwardRate(exerciseDate, model.getLiborPeriod(liborPeriodIndex), model.getLiborPeriod(liborPeriodIndexEnd));
        basisFunction = basisFunction.discount(rate, periodLength);
        basisFunctions.add(basisFunction);
        basisFunction = basisFunction.discount(rate, periodLength);
        basisFunctions.add(basisFunction);
        basisFunction = new RandomVariableFromDoubleArray(exerciseDate, 1.0);
        liborPeriodIndex = model.getLiborPeriodIndex(exerciseDate);
        liborPeriodIndexEnd = (liborPeriodIndex + model.getNumberOfLibors()) / 2;
        periodLength = model.getLiborPeriod(liborPeriodIndexEnd) - model.getLiborPeriod(liborPeriodIndex);
        rate = model.getForwardRate(exerciseDate, model.getLiborPeriod(liborPeriodIndex), model.getLiborPeriod(liborPeriodIndexEnd));
        basisFunction = basisFunction.discount(rate, periodLength);
        basisFunctions.add(basisFunction);
        basisFunction = basisFunction.discount(rate, periodLength);
        basisFunctions.add(basisFunction);
        basisFunction = basisFunction.discount(rate, periodLength);
        basisFunctions.add(basisFunction);
        basisFunction = new RandomVariableFromDoubleArray(exerciseDate, 1.0);
        liborPeriodIndex = model.getLiborPeriodIndex(exerciseDate);
        liborPeriodIndexEnd = model.getNumberOfLibors();
        periodLength = model.getLiborPeriod(liborPeriodIndexEnd) - model.getLiborPeriod(liborPeriodIndex);
        rate = model.getForwardRate(exerciseDate, model.getLiborPeriod(liborPeriodIndex), model.getLiborPeriod(liborPeriodIndexEnd));
        basisFunction = basisFunction.discount(rate, periodLength);
        basisFunctions.add(basisFunction);
        basisFunction = basisFunction.discount(rate, periodLength);
        basisFunctions.add(basisFunction);
        return basisFunctions.toArray(new RandomVariable[0]);
    }
}

