/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.components;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import net.finmath.concurrency.FutureWrapper;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.MonteCarloProduct;
import net.finmath.montecarlo.interestrate.TermStructureMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.stochastic.RandomVariable;

public class ProductCollection
extends AbstractProductComponent {
    private static final long serialVersionUID = -3058874897795789705L;
    private final Collection<AbstractProductComponent> products;

    public ProductCollection(AbstractProductComponent ... products) {
        this(Arrays.asList(products));
    }

    public ProductCollection(Collection<AbstractProductComponent> products) {
        this.products = products;
    }

    @Override
    public String getCurrency() {
        return this.products.iterator().next().getCurrency();
    }

    public Collection<AbstractProductComponent> getProducts() {
        return Collections.unmodifiableCollection(this.products);
    }

    @Override
    public Set<String> queryUnderlyings() {
        Set<String> underlyingNames = null;
        for (AbstractProductComponent product : this.products) {
            Set<String> productUnderlyingNames = product.queryUnderlyings();
            if (productUnderlyingNames == null) continue;
            if (underlyingNames == null) {
                underlyingNames = productUnderlyingNames;
                continue;
            }
            underlyingNames.addAll(productUnderlyingNames);
        }
        return underlyingNames;
    }

    @Override
    public RandomVariable getValue(final double evaluationTime, final TermStructureMonteCarloSimulationModel model) throws CalculationException {
        ArrayList<Future> results = new ArrayList<Future>();
        for (final MonteCarloProduct monteCarloProduct : this.products) {
            Future valueFuture;
            try {
                valueFuture = ProductCollection.getExecutor().submit(new Callable<RandomVariable>(){

                    @Override
                    public RandomVariable call() throws CalculationException {
                        return monteCarloProduct.getValue(evaluationTime, model);
                    }
                });
            }
            catch (RejectedExecutionException e) {
                valueFuture = new FutureWrapper<RandomVariable>(monteCarloProduct.getValue(evaluationTime, model));
            }
            results.add(valueFuture);
        }
        RandomVariable values = model.getRandomVariableForConstant(0.0);
        try {
            for (Future valueFuture : results) {
                values = values.add((RandomVariable)valueFuture.get());
            }
        }
        catch (InterruptedException interruptedException) {
            throw interruptedException.getCause() instanceof CalculationException ? (CalculationException)interruptedException.getCause() : new CalculationException(interruptedException.getCause());
        }
        catch (ExecutionException executionException) {
            if (CalculationException.class.isInstance(executionException.getCause())) {
                throw (CalculationException)executionException.getCause();
            }
            if (RuntimeException.class.isInstance(executionException.getCause())) {
                throw (RuntimeException)executionException.getCause();
            }
            throw new CalculationException(executionException.getCause());
        }
        return values;
    }

    @Override
    public String toString() {
        return "ProductCollection [products=" + this.products + "]";
    }
}

