/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.indices;

import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.TermStructureMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.indices.AbstractIndex;
import net.finmath.stochastic.RandomVariable;

public class CappedFlooredIndex
extends AbstractIndex {
    private static final long serialVersionUID = 7835825574794506180L;
    private final AbstractIndex index;
    private final AbstractIndex cap;
    private final AbstractIndex floor;

    public CappedFlooredIndex(AbstractIndex index, AbstractIndex cap, AbstractIndex floor) {
        this.index = index;
        this.cap = cap;
        this.floor = floor;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, TermStructureMonteCarloSimulationModel model) throws CalculationException {
        RandomVariable indexValues = this.index.getValue(evaluationTime, model);
        if (this.floor != null) {
            indexValues = indexValues.floor(this.floor.getValue(evaluationTime, model));
        }
        if (this.cap != null) {
            indexValues = indexValues.cap(this.cap.getValue(evaluationTime, model));
        }
        return indexValues;
    }

    @Override
    public Set<String> queryUnderlyings() {
        Set<String> underlyingNamesFloor;
        Set<String> underlyingNamesCap;
        Set<String> underlyingNames = this.index != null ? this.index.queryUnderlyings() : null;
        Set<String> set = underlyingNamesCap = this.cap != null ? this.cap.queryUnderlyings() : null;
        if (underlyingNamesCap != null) {
            if (underlyingNames != null) {
                underlyingNames.addAll(underlyingNamesCap);
            } else {
                underlyingNames = underlyingNamesCap;
            }
        }
        Set<String> set2 = underlyingNamesFloor = this.floor != null ? this.floor.queryUnderlyings() : null;
        if (underlyingNamesFloor != null) {
            if (underlyingNames != null) {
                underlyingNames.addAll(underlyingNamesFloor);
            } else {
                underlyingNames = underlyingNamesFloor;
            }
        }
        return underlyingNames;
    }

    @Override
    public String toString() {
        return "CappedFlooredIndex [index=" + this.index + ", cap=" + this.cap + ", floor=" + this.floor + ", toString()=" + super.toString() + "]";
    }
}

