/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.indices;

import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.TermStructureMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.montecarlo.interestrate.products.indices.AbstractIndex;
import net.finmath.stochastic.RandomVariable;

public class LinearCombinationIndex
extends AbstractIndex {
    private static final long serialVersionUID = -8181742829635380940L;
    private final AbstractProductComponent index1;
    private final AbstractProductComponent index2;
    private final double scaling1;
    private final double scaling2;

    public LinearCombinationIndex(double scaling1, AbstractProductComponent index1, double scaling2, AbstractProductComponent index2) {
        this.scaling1 = scaling1;
        this.index1 = index1;
        this.scaling2 = scaling2;
        this.index2 = index2;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, TermStructureMonteCarloSimulationModel model) throws CalculationException {
        return this.index1.getValue(evaluationTime, model).mult(this.scaling1).addProduct(this.index2.getValue(evaluationTime, model), this.scaling2);
    }

    public AbstractProductComponent getIndex1() {
        return this.index1;
    }

    public AbstractProductComponent getIndex2() {
        return this.index2;
    }

    public double getScaling1() {
        return this.scaling1;
    }

    public double getScaling2() {
        return this.scaling2;
    }

    @Override
    public Set<String> queryUnderlyings() {
        Set<String> underlyingNames = this.index1.queryUnderlyings();
        Set<String> underlyingNames2 = this.index2.queryUnderlyings();
        if (underlyingNames2 != null) {
            if (underlyingNames != null) {
                underlyingNames.addAll(underlyingNames2);
            } else {
                underlyingNames = underlyingNames2;
            }
        }
        return underlyingNames;
    }

    @Override
    public String toString() {
        return "LinearCombinationIndex [index1=" + this.index1 + ", index2=" + this.index2 + ", scaling1=" + this.scaling1 + ", scaling2=" + this.scaling2 + ", toString()=" + super.toString() + "]";
    }
}

