/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.indices;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.montecarlo.interestrate.TermStructureMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.indices.AbstractIndex;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.FloatingpointDate;
import net.finmath.time.businessdaycalendar.BusinessdayCalendar;
import net.finmath.time.daycount.DayCountConvention;

public class NumerairePerformanceIndex
extends AbstractIndex {
    private static final long serialVersionUID = 1L;
    private final String paymentOffsetCode;
    private final BusinessdayCalendar paymentBusinessdayCalendar;
    private final BusinessdayCalendar.DateRollConvention paymentDateRollConvention;
    private final DayCountConvention daycountConvention;

    public NumerairePerformanceIndex(String name, String currency, String paymentOffsetCode, BusinessdayCalendar paymentBusinessdayCalendar, BusinessdayCalendar.DateRollConvention paymentDateRollConvention, DayCountConvention daycountConvention) {
        super(name, currency);
        this.paymentOffsetCode = paymentOffsetCode;
        this.paymentBusinessdayCalendar = paymentBusinessdayCalendar;
        this.paymentDateRollConvention = paymentDateRollConvention;
        this.daycountConvention = daycountConvention;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, TermStructureMonteCarloSimulationModel model) throws CalculationException {
        double fixingTime = evaluationTime;
        LocalDateTime referenceDate = model.getReferenceDate();
        LocalDateTime fixingDate = FloatingpointDate.getDateFromFloatingPointDate(referenceDate, fixingTime);
        LocalDate paymentDate = this.paymentBusinessdayCalendar.getAdjustedDate(fixingDate.toLocalDate(), this.paymentOffsetCode, this.paymentDateRollConvention);
        double paymentTime = FloatingpointDate.getFloatingPointDateFromDate(referenceDate, LocalDateTime.of(paymentDate, fixingDate.toLocalTime()));
        double periodLength = this.daycountConvention.getDaycountFraction(fixingDate.toLocalDate(), paymentDate);
        RandomVariable numeraireAtStart = model.getNumeraire(fixingTime);
        RandomVariable numeraireAtEnd = model.getNumeraire(paymentTime);
        RandomVariable numeraireRatio = numeraireAtEnd.div(numeraireAtStart);
        if (this.getName() != null && !model.getModel().getDiscountCurve().getName().equals(this.getName())) {
            AnalyticModel analyticModel = model.getModel().getAnalyticModel();
            DiscountCurve indexDiscountCurve = analyticModel.getDiscountCurve(this.getName());
            DiscountCurve modelDisountCurve = model.getModel().getDiscountCurve();
            double forwardBondOnIndexCurve = indexDiscountCurve.getDiscountFactor(analyticModel, fixingTime) / indexDiscountCurve.getDiscountFactor(analyticModel, paymentTime);
            double forwardBondOnModelCurve = modelDisountCurve.getDiscountFactor(analyticModel, fixingTime) / modelDisountCurve.getDiscountFactor(analyticModel, paymentTime);
            double adjustment = forwardBondOnModelCurve / forwardBondOnIndexCurve;
            numeraireRatio = numeraireRatio.mult(adjustment);
        }
        RandomVariable forwardRate = numeraireRatio.sub(1.0).div(periodLength);
        return forwardRate;
    }

    @Override
    public Set<String> queryUnderlyings() {
        HashSet<String> underlyingNames = new HashSet<String>();
        underlyingNames.add(this.getName());
        return underlyingNames;
    }

    @Override
    public String toString() {
        return "NumerairePerformanceIndex [paymentOffsetCode=" + this.paymentOffsetCode + ", paymentBusinessdayCalendar=" + this.paymentBusinessdayCalendar + ", paymentDateRollConvention=" + this.paymentDateRollConvention + ", daycountConvention=" + this.daycountConvention + "]";
    }
}

