/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.indices;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.montecarlo.interestrate.TermStructureMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.indices.AbstractIndex;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.FloatingpointDate;
import net.finmath.time.Period;
import net.finmath.time.Schedule;

public class NumerairePerformanceOnScheduleIndex
extends AbstractIndex {
    private static final long serialVersionUID = 1L;
    private final Schedule schedule;

    public NumerairePerformanceOnScheduleIndex(String name, String currency, Schedule schedule) {
        super(name, currency);
        this.schedule = schedule;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, TermStructureMonteCarloSimulationModel model) throws CalculationException {
        double fixingTime = evaluationTime;
        Period period = this.getPeriod(FloatingpointDate.getDateFromFloatingPointDate(model.getReferenceDate(), fixingTime));
        LocalDate paymentDate = period.getPayment();
        double paymentTime = FloatingpointDate.getFloatingPointDateFromDate(model.getReferenceDate().toLocalDate(), paymentDate);
        double periodLength = this.schedule.getDaycountconvention().getDaycountFraction(period.getPeriodStart(), period.getPeriodEnd());
        RandomVariable numeraireAtStart = model.getNumeraire(fixingTime);
        RandomVariable numeraireAtEnd = model.getNumeraire(paymentTime);
        RandomVariable numeraireRatio = numeraireAtEnd.div(numeraireAtStart);
        if (this.getName() != null && !model.getModel().getDiscountCurve().getName().equals(this.getName())) {
            AnalyticModel analyticModel = model.getModel().getAnalyticModel();
            DiscountCurve indexDiscountCurve = analyticModel.getDiscountCurve(this.getName());
            DiscountCurve modelDisountCurve = model.getModel().getDiscountCurve();
            double forwardBondOnIndexCurve = indexDiscountCurve.getDiscountFactor(analyticModel, fixingTime) / indexDiscountCurve.getDiscountFactor(analyticModel, paymentTime);
            double forwardBondOnModelCurve = modelDisountCurve.getDiscountFactor(analyticModel, fixingTime) / modelDisountCurve.getDiscountFactor(analyticModel, paymentTime);
            double adjustment = forwardBondOnModelCurve / forwardBondOnIndexCurve;
            numeraireRatio = numeraireRatio.mult(adjustment);
        }
        RandomVariable forwardRate = numeraireRatio.sub(1.0).div(periodLength);
        return forwardRate;
    }

    private Period getPeriod(LocalDateTime localDateTime) {
        for (Period period : this.schedule.getPeriods()) {
            if (!period.getFixing().isEqual(localDateTime.toLocalDate())) continue;
            return period;
        }
        return null;
    }

    @Override
    public Set<String> queryUnderlyings() {
        HashSet<String> underlyingNames = new HashSet<String>();
        underlyingNames.add(this.getName());
        return underlyingNames;
    }

    @Override
    public String toString() {
        return "NumerairePerformanceOnScheduleIndex [schedule=" + this.schedule + "]";
    }
}

