/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.indices;

import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.TermStructureMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.montecarlo.interestrate.products.indices.AbstractIndex;
import net.finmath.stochastic.RandomVariable;

public class TriggerIndex
extends AbstractIndex {
    private static final long serialVersionUID = 2329303879116802448L;
    private final AbstractProductComponent trigger;
    private final AbstractProductComponent indexIfTriggerIsPositive;
    private final AbstractProductComponent indexIfTriggerIsNegative;

    public TriggerIndex(AbstractProductComponent trigger, AbstractProductComponent indexIfTriggerIsPositive, AbstractProductComponent indexIfTriggerIsNegative) {
        this.trigger = trigger;
        this.indexIfTriggerIsPositive = indexIfTriggerIsPositive;
        this.indexIfTriggerIsNegative = indexIfTriggerIsNegative;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, TermStructureMonteCarloSimulationModel model) throws CalculationException {
        RandomVariable valueTrigger = this.trigger.getValue(evaluationTime, model);
        RandomVariable valueIfTriggerNonNegative = this.indexIfTriggerIsPositive.getValue(evaluationTime, model);
        RandomVariable valueIfTriggerIsNegative = this.indexIfTriggerIsNegative.getValue(evaluationTime, model);
        return valueTrigger.choose(valueIfTriggerNonNegative, valueIfTriggerIsNegative);
    }

    @Override
    public Set<String> queryUnderlyings() {
        Set<String> underlyingNamesNegative;
        Set<String> underlyingNames = this.trigger.queryUnderlyings();
        Set<String> underlyingNamesPositive = this.indexIfTriggerIsPositive.queryUnderlyings();
        if (underlyingNamesPositive != null) {
            if (underlyingNames != null) {
                underlyingNames.addAll(underlyingNamesPositive);
            } else {
                underlyingNames = underlyingNamesPositive;
            }
        }
        if ((underlyingNamesNegative = this.indexIfTriggerIsNegative.queryUnderlyings()) != null) {
            if (underlyingNames != null) {
                underlyingNames.addAll(underlyingNamesNegative);
            } else {
                underlyingNames = underlyingNamesNegative;
            }
        }
        return underlyingNames;
    }

    @Override
    public String toString() {
        return "TriggerIndex [trigger=" + this.trigger + ", indexIfTriggerIsPositive=" + this.indexIfTriggerIsPositive + ", indexIfTriggerIsNegative=" + this.indexIfTriggerIsNegative + ", toString()=" + super.toString() + "]";
    }
}

