/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.model;

import java.time.LocalDateTime;
import net.finmath.montecarlo.model.ProcessModel;
import net.finmath.montecarlo.process.MonteCarloProcess;
import net.finmath.stochastic.RandomVariable;

public abstract class AbstractProcessModel
implements ProcessModel {
    public RandomVariable[] getInitialValue(MonteCarloProcess process) {
        RandomVariable[] initialState = this.getInitialState(process);
        RandomVariable[] value = new RandomVariable[initialState.length];
        for (int i = 0; i < value.length; ++i) {
            value[i] = this.applyStateSpaceTransform(process, 0, i, initialState[i]);
        }
        return value;
    }

    @Override
    public LocalDateTime getReferenceDate() {
        throw new UnsupportedOperationException("This model does not provide a reference date. Reference dates will be mandatory in a future version.");
    }
}

