/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.optimizer;

import net.finmath.optimizer.LevenbergMarquardt;
import net.finmath.optimizer.Optimizer;
import net.finmath.optimizer.OptimizerFactory;
import net.finmath.optimizer.SolverException;

public class OptimizerFactoryLevenbergMarquardt
implements OptimizerFactory {
    private final LevenbergMarquardt.RegularizationMethod regularizationMethod;
    private final double lambda;
    private final int maxIterations;
    private final double errorTolerance;
    private final int maxThreads;

    public OptimizerFactoryLevenbergMarquardt(LevenbergMarquardt.RegularizationMethod regularizationMethod, double lambda, int maxIterations, double errorTolerance, int maxThreads) {
        this.regularizationMethod = regularizationMethod;
        this.lambda = lambda;
        this.maxIterations = maxIterations;
        this.errorTolerance = errorTolerance;
        this.maxThreads = maxThreads;
    }

    public OptimizerFactoryLevenbergMarquardt(LevenbergMarquardt.RegularizationMethod regularizationMethod, int maxIterations, double errorTolerance, int maxThreads) {
        this(regularizationMethod, 0.001, maxIterations, errorTolerance, maxThreads);
    }

    public OptimizerFactoryLevenbergMarquardt(int maxIterations, double errorTolerance, int maxThreads) {
        this(LevenbergMarquardt.RegularizationMethod.LEVENBERG_MARQUARDT, maxIterations, errorTolerance, maxThreads);
    }

    public OptimizerFactoryLevenbergMarquardt(int maxIterations, int maxThreads) {
        this(maxIterations, 0.0, maxThreads);
    }

    @Override
    public Optimizer getOptimizer(Optimizer.ObjectiveFunction objectiveFunction, double[] initialParameters, double[] targetValues) {
        return this.getOptimizer(objectiveFunction, initialParameters, null, null, null, targetValues);
    }

    @Override
    public Optimizer getOptimizer(Optimizer.ObjectiveFunction objectiveFunction, double[] initialParameters, double[] lowerBound, double[] upperBound, double[] targetValues) {
        return this.getOptimizer(objectiveFunction, initialParameters, lowerBound, upperBound, null, targetValues);
    }

    @Override
    public Optimizer getOptimizer(final Optimizer.ObjectiveFunction objectiveFunction, double[] initialParameters, double[] lowerBound, double[] upperBound, double[] parameterSteps, double[] targetValues) {
        return new LevenbergMarquardt(this.regularizationMethod, initialParameters, targetValues, this.maxIterations, this.maxThreads){
            private static final long serialVersionUID = -1628631567190057495L;

            @Override
            public void setValues(double[] parameters, double[] values) throws SolverException {
                objectiveFunction.setValues(parameters, values);
            }
        }.setLambda(this.lambda).setErrorTolerance(this.errorTolerance).setParameterSteps(parameterSteps);
    }
}

