/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.optimizer;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.finmath.montecarlo.automaticdifferentiation.RandomVariableDifferentiable;
import net.finmath.optimizer.SolverException;
import net.finmath.optimizer.StochasticLevenbergMarquardt;
import net.finmath.stochastic.RandomVariable;

public abstract class StochasticLevenbergMarquardtAD
extends StochasticLevenbergMarquardt {
    private static final long serialVersionUID = -8852002990042152135L;
    private static final Logger logger = Logger.getLogger("net.finmath");
    private final boolean isGradientValuationParallel;

    public StochasticLevenbergMarquardtAD(StochasticLevenbergMarquardt.RegularizationMethod regularizationMethod, RandomVariable[] initialParameters, RandomVariable[] targetValues, RandomVariable[] parameterSteps, int maxIteration, double errorTolerance, ExecutorService executorService, boolean isGradientValuationParallel) {
        super(regularizationMethod, initialParameters, targetValues, parameterSteps, maxIteration, errorTolerance, executorService);
        this.isGradientValuationParallel = isGradientValuationParallel;
    }

    public StochasticLevenbergMarquardtAD(StochasticLevenbergMarquardt.RegularizationMethod regularizationMethod, RandomVariable[] initialParameters, RandomVariable[] targetValues, RandomVariable[] parameterSteps, int maxIteration, double errorTolerance, ExecutorService executorService) {
        this(regularizationMethod, initialParameters, targetValues, parameterSteps, maxIteration, errorTolerance, executorService, false);
    }

    @Override
    protected void prepareAndSetValues(RandomVariable[] parameters, RandomVariable[] values) throws SolverException {
        for (int i = 0; i < parameters.length; ++i) {
            if (!(parameters[i] instanceof RandomVariableDifferentiable)) continue;
            parameters[i] = ((RandomVariableDifferentiable)parameters[i]).getCloneIndependent();
        }
        this.setValues(parameters, values);
    }

    @Override
    protected void prepareAndSetDerivatives(RandomVariable[] parameters, final RandomVariable[] values, RandomVariable[][] derivatives) throws SolverException {
        int valueIndex;
        boolean isParameterRandomVariableDifferentiable = true;
        for (int parameterIndex = 0; parameterIndex < parameters.length && isParameterRandomVariableDifferentiable; ++parameterIndex) {
            isParameterRandomVariableDifferentiable = parameters[parameterIndex] instanceof RandomVariableDifferentiable && isParameterRandomVariableDifferentiable;
        }
        if (logger.isLoggable(Level.INFO)) {
            boolean isValueRandomVariableDifferentiable = true;
            for (valueIndex = 0; valueIndex < values.length && isParameterRandomVariableDifferentiable; ++valueIndex) {
                isValueRandomVariableDifferentiable = values[valueIndex] instanceof RandomVariableDifferentiable && isValueRandomVariableDifferentiable;
            }
            if (!isValueRandomVariableDifferentiable) {
                logger.info("Using " + this.getClass().getSimpleName() + " with random variables not implementing " + RandomVariableDifferentiable.class.getSimpleName());
            }
        }
        if (isParameterRandomVariableDifferentiable) {
            Map gradients = null;
            if (this.isGradientValuationParallel) {
                gradients = IntStream.range(0, values.length).parallel().boxed().collect(Collectors.toConcurrentMap(Function.identity(), new Function<Integer, Map<Long, RandomVariable>>(){

                    @Override
                    public Map<Long, RandomVariable> apply(Integer valueIndex) {
                        return ((RandomVariableDifferentiable)values[valueIndex]).getGradient();
                    }
                }));
            }
            for (valueIndex = 0; valueIndex < values.length; ++valueIndex) {
                if (!(values[valueIndex] instanceof RandomVariableDifferentiable)) continue;
                Map<Long, RandomVariable> gradient = gradients != null ? (Map<Long, RandomVariable>)gradients.get(valueIndex) : ((RandomVariableDifferentiable)values[valueIndex]).getGradient();
                for (int parameterIndex = 0; parameterIndex < parameters.length; ++parameterIndex) {
                    derivatives[parameterIndex][valueIndex] = gradient.get(((RandomVariableDifferentiable)parameters[parameterIndex]).getID());
                    if (derivatives[parameterIndex][valueIndex] == null) continue;
                    derivatives[parameterIndex][valueIndex] = derivatives[parameterIndex][valueIndex].average();
                }
            }
        } else {
            this.setDerivatives(parameters, derivatives);
        }
    }
}

