/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.optimizer;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import net.finmath.montecarlo.automaticdifferentiation.RandomVariableDifferentiable;
import net.finmath.optimizer.SolverException;
import net.finmath.optimizer.StochasticPathwiseLevenbergMarquardt;
import net.finmath.stochastic.RandomVariable;

public abstract class StochasticPathwiseLevenbergMarquardtAD
extends StochasticPathwiseLevenbergMarquardt {
    private static final long serialVersionUID = -8852002990042152135L;

    public StochasticPathwiseLevenbergMarquardtAD(List<RandomVariable> initialParameters, List<RandomVariable> targetValues, int maxIteration, ExecutorService executorService) {
        super(initialParameters, targetValues, maxIteration, executorService);
    }

    public StochasticPathwiseLevenbergMarquardtAD(List<RandomVariable> initialParameters, List<RandomVariable> targetValues, int maxIteration, int numberOfThreads) {
        super(initialParameters, targetValues, maxIteration, numberOfThreads);
    }

    public StochasticPathwiseLevenbergMarquardtAD(RandomVariable[] initialParameters, RandomVariable[] targetValues, int maxIteration, int numberOfThreads) {
        super(initialParameters, targetValues, maxIteration, numberOfThreads);
    }

    public StochasticPathwiseLevenbergMarquardtAD(RandomVariable[] initialParameters, RandomVariable[] targetValues, RandomVariable[] weights, RandomVariable[] parameterSteps, int maxIteration, RandomVariable errorTolerance, ExecutorService executorService) {
        super(initialParameters, targetValues, weights, parameterSteps, maxIteration, errorTolerance, executorService);
    }

    @Override
    protected void prepareAndSetValues(RandomVariable[] parameters, RandomVariable[] values) throws SolverException {
        for (int i = 0; i < parameters.length; ++i) {
            if (!(parameters[i] instanceof RandomVariableDifferentiable)) continue;
            parameters[i] = ((RandomVariableDifferentiable)parameters[i]).getCloneIndependent();
        }
        this.setValues(parameters, values);
    }

    @Override
    protected void prepareAndSetDerivatives(RandomVariable[] parameters, RandomVariable[] values, RandomVariable[][] derivatives) throws SolverException {
        int valueIndex;
        boolean isRandomVariableDifferentiable = true;
        for (int parameterIndex = 0; parameterIndex < parameters.length && isRandomVariableDifferentiable; ++parameterIndex) {
            isRandomVariableDifferentiable = parameters[parameterIndex] instanceof RandomVariableDifferentiable && isRandomVariableDifferentiable;
        }
        for (valueIndex = 0; valueIndex < values.length && isRandomVariableDifferentiable; ++valueIndex) {
            isRandomVariableDifferentiable = values[valueIndex] instanceof RandomVariableDifferentiable && isRandomVariableDifferentiable;
        }
        if (isRandomVariableDifferentiable) {
            for (valueIndex = 0; valueIndex < values.length; ++valueIndex) {
                Map<Long, RandomVariable> gradient = ((RandomVariableDifferentiable)values[valueIndex]).getGradient();
                for (int parameterIndex = 0; parameterIndex < parameters.length; ++parameterIndex) {
                    derivatives[parameterIndex][valueIndex] = gradient.get(((RandomVariableDifferentiable)parameters[parameterIndex]).getID());
                }
            }
        } else {
            this.setDerivatives(parameters, derivatives);
        }
    }
}

