/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.randomnumbers;

import java.util.function.DoubleUnaryOperator;
import net.finmath.randomnumbers.RandomNumberGenerator;
import org.apache.commons.lang3.Validate;

public class AcceptanceRejectionRandomNumberGenerator
implements RandomNumberGenerator {
    private static final long serialVersionUID = -9060003224133337426L;
    private final RandomNumberGenerator uniformRandomNumberGenerator;
    private final DoubleUnaryOperator targetDensity;
    private final DoubleUnaryOperator referenceDensity;
    private final DoubleUnaryOperator referenceDistributionICDF;
    private final double acceptanceLevel;

    public AcceptanceRejectionRandomNumberGenerator(RandomNumberGenerator uniformRandomNumberGenerator, DoubleUnaryOperator targetDensity, DoubleUnaryOperator referenceDensity, DoubleUnaryOperator referenceDistributionICDF, double acceptanceLevel) {
        Validate.inclusiveBetween((long)2L, (long)Integer.MAX_VALUE, (long)uniformRandomNumberGenerator.getDimension(), (String)"The acceptance rejection method requires a uniform distributed random number generator with at least dimension 2.");
        this.uniformRandomNumberGenerator = uniformRandomNumberGenerator;
        this.targetDensity = targetDensity;
        this.referenceDensity = referenceDensity;
        this.referenceDistributionICDF = referenceDistributionICDF;
        this.acceptanceLevel = acceptanceLevel;
    }

    @Override
    public double[] getNext() {
        boolean rejected = true;
        double y = Double.NaN;
        while (rejected) {
            double[] uniform = this.uniformRandomNumberGenerator.getNext();
            double u = uniform[0];
            y = this.referenceDistributionICDF.applyAsDouble(uniform[1]);
            rejected = this.targetDensity.applyAsDouble(y) < u * this.acceptanceLevel * this.referenceDensity.applyAsDouble(y);
        }
        return new double[]{y};
    }

    @Override
    public int getDimension() {
        return 1;
    }
}

