/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.randomnumbers;

import java.util.concurrent.atomic.AtomicLong;
import net.finmath.randomnumbers.RandomNumberGenerator;

public class HaltonSequence
implements RandomNumberGenerator {
    private static final long serialVersionUID = -4799340450248196350L;
    private final int[] base;
    private final AtomicLong currentIndex = new AtomicLong();

    public HaltonSequence(int[] base) {
        for (int i = 0; i < base.length; ++i) {
            if (base[i] > 1) continue;
            throw new IllegalArgumentException("base needs to be larger than 1");
        }
        this.base = base;
    }

    @Override
    public double[] getNext() {
        return this.getHaltonNumber(this.currentIndex.getAndIncrement());
    }

    @Override
    public int getDimension() {
        return this.base.length;
    }

    public double[] getHaltonNumber(long index) {
        double[] x = new double[this.base.length];
        for (int dimension = 0; dimension < this.base.length; ++dimension) {
            x[dimension] = HaltonSequence.getHaltonNumberForGivenBase(index, this.base[dimension]);
        }
        return x;
    }

    public double getHaltonNumber(long index, int dimension) {
        return HaltonSequence.getHaltonNumberForGivenBase(index, this.base[dimension]);
    }

    public static double getHaltonNumberForGivenBase(long index, int base) {
        ++index;
        double x = 0.0;
        double factor = 1.0 / (double)base;
        while (index > 0L) {
            x += (double)(index % (long)base) * factor;
            factor /= (double)base;
            index /= (long)base;
        }
        return x;
    }
}

