/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.rootfinder;

import net.finmath.rootfinder.StochasticRootFinderUsingDerivative;
import net.finmath.stochastic.RandomVariable;

public class StochasticNewtonMethod
implements StochasticRootFinderUsingDerivative {
    private RandomVariable nextPoint;
    private RandomVariable bestPoint;
    private int numberOfIterations = 0;
    private double accuracy = Double.MAX_VALUE;
    private final boolean isDone = false;
    private final MethodForAccuracy method;

    public StochasticNewtonMethod(RandomVariable guess, MethodForAccuracy method) {
        this.bestPoint = guess;
        this.nextPoint = guess;
        this.method = method;
    }

    @Override
    public RandomVariable getNextPoint() {
        return this.nextPoint;
    }

    @Override
    public void setValueAndDerivative(RandomVariable value, RandomVariable derivative) {
        double currentAccuracy;
        switch (this.method) {
            case AVERAGE: {
                currentAccuracy = value.abs().getAverage();
                break;
            }
            case MAX: {
                currentAccuracy = value.abs().getMax();
                break;
            }
            case MIN: {
                currentAccuracy = value.abs().getMin();
                break;
            }
            default: {
                throw new IllegalArgumentException("Method to get current accuracy from RandomVariable not supported!");
            }
        }
        if (currentAccuracy < this.accuracy) {
            this.accuracy = currentAccuracy;
            this.bestPoint = this.nextPoint;
        }
        this.nextPoint = this.nextPoint.addRatio(value, derivative);
        ++this.numberOfIterations;
    }

    @Override
    public int getNumberOfIterations() {
        return this.numberOfIterations;
    }

    @Override
    public double getAccuracy() {
        return this.accuracy;
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public RandomVariable getBestPoint() {
        return this.bestPoint;
    }

    public static enum MethodForAccuracy {
        AVERAGE,
        MAX,
        MIN;

    }
}

