/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.singleswaprate.annuitymapping;

import java.util.Arrays;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.volatilities.VolatilitySurface;
import net.finmath.marketdata.products.SwapAnnuity;
import net.finmath.singleswaprate.annuitymapping.AnnuityMapping;
import net.finmath.singleswaprate.annuitymapping.ExponentialNormalizer;
import net.finmath.singleswaprate.annuitymapping.NormalizingFunction;
import net.finmath.singleswaprate.model.VolatilityCubeModel;
import net.finmath.singleswaprate.model.volatilities.VolVolCube;
import net.finmath.singleswaprate.model.volatilities.VolatilityCube;
import net.finmath.singleswaprate.products.AnnuityDummyProduct;
import net.finmath.singleswaprate.products.NormalizingDummyProduct;
import net.finmath.time.Period;
import net.finmath.time.Schedule;
import net.finmath.time.ScheduleFromPeriods;

public class BasicPiterbargAnnuityMapping
implements AnnuityMapping {
    private static VolatilitySurface.QuotingConvention quotingConvention = VolatilitySurface.QuotingConvention.VOLATILITYNORMAL;
    private final int numberOfPeriods;
    private final double[] periodLengths;
    private final double[] initialAnnuities;
    private final double[] initialSwapRates;
    private final double[] exponentialDriverMeans;
    private final double[] exponents;
    private final double[] denominators;
    private final double expectationCorrection;
    private final NormalizingFunction normalizer;

    public BasicPiterbargAnnuityMapping(Schedule fixSchedule, Schedule floatSchedule, VolatilityCubeModel model, String discountCurveName, String volatilityCubeName) {
        this(fixSchedule, floatSchedule, Double.NaN, model, discountCurveName, volatilityCubeName);
    }

    public BasicPiterbargAnnuityMapping(Schedule fixSchedule, Schedule floatSchedule, double strike, VolatilityCubeModel model, String discountCurveName, String volatilityCubeName) {
        this(fixSchedule, floatSchedule, strike, model, discountCurveName, volatilityCubeName, 0.0, 0.0, -1);
    }

    public BasicPiterbargAnnuityMapping(Schedule fixSchedule, Schedule floatSchedule, double strike, VolatilityCubeModel model, String discountCurveName, String volatilityCubeName, double lowerBound, double upperBound, int numberOfEvaluationPoints) {
        this.numberOfPeriods = fixSchedule.getNumberOfPeriods();
        double maturity = fixSchedule.getPeriodStart(0);
        double[] periodLengths = new double[this.numberOfPeriods];
        double[] periodEnds = new double[this.numberOfPeriods];
        for (int index = 0; index < this.numberOfPeriods; ++index) {
            periodLengths[index] = fixSchedule.getPeriodLength(index);
            periodEnds[index] = fixSchedule.getPeriodEnd(index);
        }
        this.periodLengths = periodLengths;
        this.initialAnnuities = this.getAnnuities(fixSchedule, discountCurveName, model);
        this.initialSwapRates = this.getForwardSwapRates(fixSchedule, discountCurveName, model);
        String volvolCubeName = "VolVolFrom" + volatilityCubeName;
        VolVolCube volvolCube = new VolVolCube(volvolCubeName, model.getVolatilityCube(volatilityCubeName).getReferenceDate(), volatilityCubeName, fixSchedule, this.initialSwapRates);
        if (Double.isNaN(strike)) {
            strike = this.initialSwapRates[this.numberOfPeriods - 1];
        }
        this.exponentialDriverMeans = this.findExponentialDriverMeans(periodEnds, maturity, strike, volvolCube, model);
        double[] exponents = new double[this.numberOfPeriods];
        double[] denominators = new double[this.numberOfPeriods];
        Arrays.fill(denominators, 1.0);
        double terminalVolvol = volvolCube.getValue(model, periodEnds[this.numberOfPeriods - 1], maturity, strike, quotingConvention);
        int outerIndex = this.numberOfPeriods - 1;
        while (outerIndex > -1) {
            double currentSummand = volvolCube.getValue(model, periodEnds[outerIndex], maturity, strike, quotingConvention);
            double currentFactor = (periodLengths[outerIndex] * this.initialSwapRates[outerIndex] + 1.0) * this.exponentialDriverMeans[outerIndex];
            int innerIndex = 0;
            while (innerIndex <= outerIndex) {
                int n = innerIndex;
                exponents[n] = exponents[n] + currentSummand;
                int n2 = innerIndex++;
                denominators[n2] = denominators[n2] * currentFactor;
            }
            int n = outerIndex--;
            exponents[n] = exponents[n] / terminalVolvol;
        }
        this.exponents = exponents;
        this.denominators = denominators;
        NormalizingDummyProduct unscaledNormalizerDummy = new NormalizingDummyProduct(fixSchedule, floatSchedule, discountCurveName, null, volatilityCubeName, new ExponentialNormalizer(this.initialSwapRates[this.initialSwapRates.length - 1], 1.0));
        if (numberOfEvaluationPoints > 0) {
            unscaledNormalizerDummy.setIntegrationParameters(lowerBound, upperBound, numberOfEvaluationPoints);
        }
        this.normalizer = new ExponentialNormalizer(this.initialSwapRates[this.initialSwapRates.length - 1], 1.0 / unscaledNormalizerDummy.getValue(fixSchedule.getFixing(0), model));
        BasicPiterbargAnnuityMapping uncorrectedMapping = new BasicPiterbargAnnuityMapping(this.numberOfPeriods, periodLengths, this.initialAnnuities, this.initialSwapRates, this.exponentialDriverMeans, exponents, denominators, this.normalizer);
        AnnuityDummyProduct uncorrectedAnnuityDummy = new AnnuityDummyProduct(fixSchedule, floatSchedule, discountCurveName, null, volatilityCubeName, uncorrectedMapping);
        if (numberOfEvaluationPoints > 0) {
            uncorrectedAnnuityDummy.setIntegrationParameters(lowerBound, upperBound, numberOfEvaluationPoints);
        }
        this.expectationCorrection = uncorrectedAnnuityDummy.getValue(fixSchedule.getFixing(0), model) - 1.0;
    }

    private BasicPiterbargAnnuityMapping(int numberOfPeriods, double[] periodLengths, double[] initialAnnuities, double[] initialSwapRates, double[] exponentialDriverMeans, double[] exponents, double[] denominators, NormalizingFunction normalizer) {
        this.numberOfPeriods = numberOfPeriods;
        this.periodLengths = periodLengths;
        this.initialAnnuities = initialAnnuities;
        this.initialSwapRates = initialSwapRates;
        this.exponentialDriverMeans = exponentialDriverMeans;
        this.exponents = exponents;
        this.denominators = denominators;
        this.expectationCorrection = 0.0;
        this.normalizer = normalizer;
    }

    @Override
    public double getValue(double swapRate) {
        double term = this.periodLengths[this.numberOfPeriods - 1] * swapRate + 1.0;
        term /= this.periodLengths[this.numberOfPeriods - 1] * this.initialSwapRates[this.numberOfPeriods - 1] + 1.0;
        term /= this.exponentialDriverMeans[this.numberOfPeriods - 1];
        double value = 0.0;
        for (int index = 0; index < this.numberOfPeriods; ++index) {
            value += Math.pow(term, -this.exponents[index]) * this.periodLengths[index] / this.denominators[index];
        }
        return this.initialAnnuities[this.numberOfPeriods - 1] / value - this.expectationCorrection * this.normalizer.getValue(swapRate);
    }

    @Override
    public double getFirstDerivative(double swapRate) {
        double term = this.periodLengths[this.numberOfPeriods - 1] * swapRate + 1.0;
        term /= this.periodLengths[this.numberOfPeriods - 1] * this.initialSwapRates[this.numberOfPeriods - 1] + 1.0;
        term /= this.exponentialDriverMeans[this.numberOfPeriods - 1];
        double value = 0.0;
        double innerDerivative = 0.0;
        for (int index = 0; index < this.numberOfPeriods; ++index) {
            value += Math.pow(term, -this.exponents[index]) * this.periodLengths[index] / this.denominators[index];
            innerDerivative += Math.pow(term, -this.exponents[index] - 1.0) * this.periodLengths[index] * -this.exponents[index] / this.denominators[index];
        }
        return -this.initialAnnuities[this.numberOfPeriods - 1] * (innerDerivative *= this.periodLengths[this.numberOfPeriods - 1] / this.exponentialDriverMeans[this.numberOfPeriods - 1] / (this.periodLengths[this.numberOfPeriods - 1] * this.initialSwapRates[this.numberOfPeriods - 1] + 1.0)) / value / value - this.expectationCorrection * this.normalizer.getFirstDerivative(swapRate);
    }

    @Override
    public double getSecondDerivative(double swapRate) {
        double term = this.periodLengths[this.numberOfPeriods - 1] * swapRate + 1.0;
        term /= this.periodLengths[this.numberOfPeriods - 1] * this.initialSwapRates[this.numberOfPeriods - 1] + 1.0;
        term /= this.exponentialDriverMeans[this.numberOfPeriods - 1];
        double value = 0.0;
        double innerFirst = 0.0;
        double innerSecond = 0.0;
        for (int index = 0; index < this.numberOfPeriods; ++index) {
            value += Math.pow(term, -this.exponents[0]) * this.periodLengths[index] / this.denominators[index];
            innerFirst += Math.pow(term, -this.exponents[index] - 1.0) * this.periodLengths[index] * -this.exponents[index] / this.denominators[index];
            innerSecond += Math.pow(term, -this.exponents[index] - 2.0) * this.periodLengths[index] * this.exponents[index] * (this.exponents[index] + 1.0) / this.denominators[index];
        }
        return (2.0 * (innerFirst *= this.periodLengths[this.numberOfPeriods - 1] / (this.periodLengths[this.numberOfPeriods - 1] * this.initialSwapRates[this.numberOfPeriods - 1] + 1.0) / this.exponentialDriverMeans[this.numberOfPeriods - 1]) * innerFirst / value / value / value - (innerSecond *= this.periodLengths[this.numberOfPeriods - 1] * this.periodLengths[this.numberOfPeriods - 1] / (this.periodLengths[this.numberOfPeriods - 1] * this.initialSwapRates[this.numberOfPeriods - 1] + 1.0) / (this.periodLengths[this.numberOfPeriods - 1] * this.initialSwapRates[this.numberOfPeriods - 1] + 1.0) / this.exponentialDriverMeans[this.numberOfPeriods - 1] / this.exponentialDriverMeans[this.numberOfPeriods - 1]) / value / value) * this.initialAnnuities[this.numberOfPeriods - 1] - this.expectationCorrection * this.normalizer.getSecondDerivative(swapRate);
    }

    private double[] findExponentialDriverMeans(double[] timePoints, double maturity, double strike, VolatilityCube volvolCube, VolatilityCubeModel model) {
        int index;
        double[] exponentialMeans = new double[this.numberOfPeriods];
        double[] volatilities = new double[this.numberOfPeriods];
        for (int index2 = 0; index2 < this.numberOfPeriods; ++index2) {
            volatilities[index2] = volvolCube.getValue(model, timePoints[index2], maturity, strike, quotingConvention);
        }
        exponentialMeans[0] = Math.exp(maturity * 0.5 * volatilities[0] * volatilities[0]);
        exponentialMeans[0] = exponentialMeans[0] * (this.periodLengths[0] / this.initialAnnuities[0] / (this.periodLengths[0] * this.initialSwapRates[0] + 1.0));
        double[] volatilitySums = new double[this.numberOfPeriods];
        double[] adjustmentSummands = new double[this.numberOfPeriods];
        for (index = 0; index < this.numberOfPeriods; ++index) {
            volatilitySums[index] = volatilities[0];
            adjustmentSummands[index] = 1.0;
        }
        for (index = 1; index < this.numberOfPeriods; ++index) {
            double adjustment = 0.0;
            int innerIndex = 0;
            while (innerIndex < index) {
                int n = innerIndex;
                adjustmentSummands[n] = adjustmentSummands[n] / (exponentialMeans[index - 1] * (this.periodLengths[index - 1] * this.initialSwapRates[index - 1] + 1.0));
                int n2 = innerIndex++;
                volatilitySums[n2] = volatilitySums[n2] + volatilities[index];
            }
            for (int sumIndex = 0; sumIndex < index; ++sumIndex) {
                adjustment += this.periodLengths[sumIndex] * adjustmentSummands[sumIndex] * Math.exp(maturity * volatilitySums[sumIndex] * volatilitySums[sumIndex] / 2.0);
            }
            exponentialMeans[index] = Math.exp(maturity * 0.5 * volatilities[index] * volatilities[index]);
            int n = index;
            exponentialMeans[n] = exponentialMeans[n] * this.periodLengths[index];
            int n3 = index;
            exponentialMeans[n3] = exponentialMeans[n3] + adjustment;
            int n4 = index;
            exponentialMeans[n4] = exponentialMeans[n4] / (this.initialAnnuities[index] * (this.periodLengths[index] * this.initialSwapRates[index] + 1.0));
        }
        return exponentialMeans;
    }

    private double[] getAnnuities(Schedule schedule, String discountCurveName, AnalyticModel model) {
        double[] annuities = new double[schedule.getNumberOfPeriods()];
        for (int annuityIndex = 0; annuityIndex < schedule.getNumberOfPeriods(); ++annuityIndex) {
            Period[] periods = new Period[annuityIndex + 1];
            for (int periodIndex = 0; periodIndex <= annuityIndex; ++periodIndex) {
                periods[periodIndex] = schedule.getPeriod(periodIndex);
            }
            ScheduleFromPeriods partSchedule = new ScheduleFromPeriods(schedule.getReferenceDate(), schedule.getDaycountconvention(), periods);
            annuities[annuityIndex] = SwapAnnuity.getSwapAnnuity(schedule.getFixing(0), partSchedule, model.getDiscountCurve(discountCurveName), model);
        }
        return annuities;
    }

    private double[] getForwardSwapRates(Schedule schedule, String discountCurveName, AnalyticModel model) {
        double[] swapRates = new double[schedule.getNumberOfPeriods()];
        double discount = model.getDiscountCurve(discountCurveName).getDiscountFactor(model, schedule.getFixing(0));
        for (int swapRateIndex = 0; swapRateIndex < schedule.getNumberOfPeriods(); ++swapRateIndex) {
            swapRates[swapRateIndex] = 1.0 - model.getDiscountCurve(discountCurveName).getDiscountFactor(model, schedule.getPayment(swapRateIndex)) / discount;
            int n = swapRateIndex;
            swapRates[n] = swapRates[n] / this.initialAnnuities[swapRateIndex];
        }
        return swapRates;
    }
}

