/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.singleswaprate.annuitymapping;

import java.time.LocalDate;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.model.curves.ForwardCurveFromDiscountCurve;
import net.finmath.marketdata.products.Swap;
import net.finmath.singleswaprate.annuitymapping.AnnuityMapping;
import net.finmath.singleswaprate.annuitymapping.BasicPiterbargAnnuityMapping;
import net.finmath.singleswaprate.model.VolatilityCubeModel;
import net.finmath.singleswaprate.model.volatilities.ScaledVolatilityCube;
import net.finmath.singleswaprate.model.volatilities.VolatilityCube;
import net.finmath.time.Schedule;

public class MultiPiterbargAnnuityMapping
implements AnnuityMapping {
    private final BasicPiterbargAnnuityMapping basicMapping;
    private final double iborOisDecorrelation;
    private final double oisSwapRate;
    private final double iborSwapRate;

    public MultiPiterbargAnnuityMapping(Schedule fixSchedule, Schedule floatSchedule, VolatilityCubeModel model, String discountCurveName, String forwardCurveName, String volatilityCubeName) {
        this(fixSchedule, floatSchedule, Swap.getForwardSwapRate(fixSchedule, floatSchedule, model.getForwardCurve(forwardCurveName), model), model, discountCurveName, forwardCurveName, volatilityCubeName, 0.0, 0.0, -1);
    }

    public MultiPiterbargAnnuityMapping(Schedule fixSchedule, Schedule floatSchedule, double strike, VolatilityCubeModel model, String discountCurveName, String forwardCurveName, String volatilityCubeName, double lowerBound, double upperBound, int numberOfEvaluationPoints) {
        VolatilityCube baseCube = model.getVolatilityCube(volatilityCubeName);
        LocalDate referenceDate = baseCube.getReferenceDate();
        this.iborOisDecorrelation = model.getVolatilityCube(volatilityCubeName).getIborOisDecorrelation();
        ScaledVolatilityCube tempCube = new ScaledVolatilityCube("MultiPiterbargCubeFrom" + volatilityCubeName, referenceDate, volatilityCubeName, this.iborOisDecorrelation, baseCube.getCorrelationDecay());
        VolatilityCubeModel tempModel = model.addVolatilityCube(tempCube);
        String offsetCode = MultiPiterbargAnnuityMapping.getOffsetCode(forwardCurveName);
        ForwardCurveFromDiscountCurve forwardFromDiscount = new ForwardCurveFromDiscountCurve(discountCurveName, referenceDate, offsetCode);
        this.basicMapping = new BasicPiterbargAnnuityMapping(fixSchedule, floatSchedule, strike, tempModel, discountCurveName, tempCube.getName(), lowerBound, upperBound, numberOfEvaluationPoints);
        this.iborSwapRate = Swap.getForwardSwapRate(fixSchedule, floatSchedule, model.getForwardCurve(forwardCurveName), tempModel);
        this.oisSwapRate = Swap.getForwardSwapRate(fixSchedule, floatSchedule, (ForwardCurve)forwardFromDiscount, tempModel);
    }

    @Override
    public double getValue(double swapRate) {
        return this.basicMapping.getValue(this.oisSwapRate + this.iborOisDecorrelation * (swapRate - this.iborSwapRate));
    }

    @Override
    public double getFirstDerivative(double swapRate) {
        return this.basicMapping.getFirstDerivative(this.oisSwapRate + this.iborOisDecorrelation * (swapRate - this.iborSwapRate)) * this.iborOisDecorrelation;
    }

    @Override
    public double getSecondDerivative(double swapRate) {
        return this.basicMapping.getSecondDerivative(this.oisSwapRate + this.iborOisDecorrelation * (swapRate - this.iborSwapRate)) * this.iborOisDecorrelation * this.iborOisDecorrelation;
    }

    private static String getOffsetCode(String forwardCurveName) {
        String[] splits = forwardCurveName.split("(?<=\\D)(?=\\d)");
        String offsetCode = splits[splits.length - 1];
        if (offsetCode != null && offsetCode.length() > 0 && offsetCode.charAt(offsetCode.length() - 1) == ')') {
            offsetCode = offsetCode.substring(0, offsetCode.length() - 1);
        }
        return offsetCode;
    }
}

