/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.singleswaprate.annuitymapping;

import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.model.curves.ForwardCurveFromDiscountCurve;
import net.finmath.marketdata.products.Swap;
import net.finmath.marketdata.products.SwapAnnuity;
import net.finmath.singleswaprate.annuitymapping.AnnuityMapping;
import net.finmath.time.Schedule;

public class SimplifiedLinearAnnuityMapping
implements AnnuityMapping {
    private final double slope;
    private final double intercept;
    private final double initialAnnuity;

    public SimplifiedLinearAnnuityMapping(Schedule schedule, double initialAnnuity, double initialSwapRate, double discountFactor) {
        double intercept = 0.0;
        for (int index = 0; index < schedule.getNumberOfPeriods(); ++index) {
            intercept += schedule.getPeriodLength(index);
        }
        intercept = 1.0 / intercept;
        double slope = discountFactor / initialAnnuity - intercept;
        this.intercept = intercept;
        this.slope = slope /= initialSwapRate;
        this.initialAnnuity = initialAnnuity;
    }

    public SimplifiedLinearAnnuityMapping(Schedule fixSchedule, Schedule floatSchedule, AnalyticModel model, String discountCurveName) {
        double intercept = 0.0;
        for (int index = 0; index < fixSchedule.getNumberOfPeriods(); ++index) {
            intercept += fixSchedule.getPeriodLength(index);
        }
        intercept = 1.0 / intercept;
        ForwardCurveFromDiscountCurve forwardCurve = new ForwardCurveFromDiscountCurve(discountCurveName, model.getDiscountCurve(discountCurveName).getReferenceDate() == null ? fixSchedule.getReferenceDate() : model.getDiscountCurve(discountCurveName).getReferenceDate(), "6M");
        double initialAnnuity = SwapAnnuity.getSwapAnnuity(fixSchedule.getFixing(0), fixSchedule, model.getDiscountCurve(discountCurveName), model);
        double initialSwapRate = Swap.getForwardSwapRate(fixSchedule, floatSchedule, (ForwardCurve)forwardCurve, model);
        double slope = 1.0 / initialAnnuity - intercept;
        this.intercept = intercept;
        this.slope = slope /= initialSwapRate;
        this.initialAnnuity = initialAnnuity;
    }

    @Override
    public double getValue(double swapRate) {
        return (swapRate * this.slope + this.intercept) * this.initialAnnuity;
    }

    @Override
    public double getFirstDerivative(double swapRate) {
        return this.slope * this.initialAnnuity;
    }

    @Override
    public double getSecondDerivative(double swapRate) {
        return 0.0;
    }
}

