/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.singleswaprate.calibration;

import java.time.LocalDate;
import net.finmath.marketdata.model.volatilities.SwaptionDataLattice;
import net.finmath.singleswaprate.annuitymapping.AnnuityMapping;
import net.finmath.singleswaprate.calibration.AbstractCubeCalibration;
import net.finmath.singleswaprate.model.VolatilityCubeModel;
import net.finmath.singleswaprate.model.volatilities.StaticVolatilityCube;
import net.finmath.singleswaprate.model.volatilities.VolatilityCube;

public class StaticCubeCalibration
extends AbstractCubeCalibration {
    private double initialValue = 0.005;
    private double initialCorrelationDecay = 0.0;
    private final double initialIborOisDecorrelation = 1.0;

    public StaticCubeCalibration(LocalDate referenceDate, SwaptionDataLattice cashPayerPremiums, SwaptionDataLattice cashReceiverPremiums, VolatilityCubeModel model, AnnuityMapping.AnnuityMappingType annuityMappingType) {
        super(referenceDate, cashPayerPremiums, cashReceiverPremiums, model, annuityMappingType);
    }

    public StaticCubeCalibration(LocalDate referenceDate, SwaptionDataLattice cashPayerPremiums, SwaptionDataLattice cashReceiverPremiums, VolatilityCubeModel model, AnnuityMapping.AnnuityMappingType annuityMappingType, double initialValue, double initialCorrelationDecay) {
        super(referenceDate, cashPayerPremiums, cashReceiverPremiums, model, annuityMappingType);
        this.initialValue = initialValue;
        this.initialCorrelationDecay = initialCorrelationDecay;
    }

    @Override
    protected VolatilityCube buildCube(String cubeName, double[] parameters) {
        return new StaticVolatilityCube(cubeName, this.getReferenceDate(), parameters[1], parameters[0]);
    }

    @Override
    protected void initializeParameters() {
        this.setInitialParameters(new double[]{this.initialValue, this.initialCorrelationDecay, 1.0});
    }

    @Override
    protected double[] applyParameterBounds(double[] parameters) {
        double[] boundedParameters = new double[parameters.length];
        boundedParameters[0] = Math.max(parameters[0], 0.0);
        boundedParameters[1] = Math.max(parameters[1], 0.0);
        boundedParameters[2] = parameters[2];
        return boundedParameters;
    }
}

