/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.singleswaprate.model.volatilities;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import net.finmath.marketdata.model.volatilities.VolatilitySurface;
import net.finmath.singleswaprate.model.VolatilityCubeModel;
import net.finmath.singleswaprate.model.volatilities.VolatilityCube;

public class ScaledVolatilityCube
implements VolatilityCube {
    private final String name;
    private final LocalDate referenceDate;
    private final String referenceCubeName;
    private final double coefficient;
    private final double correlationDecay;
    private final double iborOisDecorrelation;

    public ScaledVolatilityCube(String name, LocalDate referenceDate, String referenceCubeName, double coefficient, double correlationDecay, double iborOisDecorrelation) {
        this.name = name;
        this.referenceDate = referenceDate;
        this.referenceCubeName = referenceCubeName;
        this.coefficient = coefficient;
        this.correlationDecay = correlationDecay;
        this.iborOisDecorrelation = iborOisDecorrelation;
    }

    public ScaledVolatilityCube(String name, LocalDate referenceDate, String referenceCubeName, double coefficient, double correlationDecay) {
        this(name, referenceDate, referenceCubeName, coefficient, correlationDecay, 1.0);
    }

    @Override
    public double getValue(VolatilityCubeModel model, double termination, double maturity, double strike, VolatilitySurface.QuotingConvention quotingConvention) {
        return model.getVolatilityCube(this.referenceCubeName).getValue(model, termination, maturity, strike, quotingConvention) * this.coefficient;
    }

    @Override
    public double getValue(double termination, double maturity, double strike, VolatilitySurface.QuotingConvention quotingConvention) {
        return this.getValue(null, termination, maturity, strike, quotingConvention);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public LocalDate getReferenceDate() {
        return this.referenceDate;
    }

    public String getReferenceCubeName() {
        return this.referenceCubeName;
    }

    @Override
    public double getCorrelationDecay() {
        return this.correlationDecay;
    }

    @Override
    public Map<String, Object> getParameters() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("coefficient", this.coefficient);
        map.put("Inherent correlationDecay", this.correlationDecay);
        map.put("iborOisDecorrelation", this.iborOisDecorrelation);
        return map;
    }

    @Override
    public double getLowestStrike(VolatilityCubeModel model) {
        return model.getVolatilityCube(this.referenceCubeName).getLowestStrike(model);
    }

    @Override
    public double getIborOisDecorrelation() {
        return this.iborOisDecorrelation;
    }
}

