/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.singleswaprate.model.volatilities;

import java.time.LocalDate;
import java.util.Map;
import net.finmath.interpolation.RationalFunctionInterpolation;
import net.finmath.marketdata.model.volatilities.VolatilitySurface;
import net.finmath.singleswaprate.model.VolatilityCubeModel;
import net.finmath.singleswaprate.model.curves.ExponentialCorrelationCurve;
import net.finmath.singleswaprate.model.volatilities.VolatilityCube;
import net.finmath.time.Schedule;

public class VolVolCube
implements VolatilityCube {
    private final String name;
    private final LocalDate referenceDate;
    private final String referenceCubeName;
    private final double baseTermination;
    private final double periodLength;
    private final RationalFunctionInterpolation rateInterpolator;
    private final VolatilitySurface.QuotingConvention quotingConvention = VolatilitySurface.QuotingConvention.VOLATILITYNORMAL;

    public VolVolCube(String name, LocalDate referenceDate, String referenceCubeName, Schedule schedule, double[] initialSwapRates) {
        this.name = name;
        this.referenceDate = referenceDate;
        this.referenceCubeName = referenceCubeName;
        this.baseTermination = schedule.getPayment(schedule.getNumberOfPeriods() - 1);
        double periodLength = 0.0;
        for (int index = 0; index < schedule.getNumberOfPeriods(); ++index) {
            periodLength += schedule.getPeriodLength(index);
        }
        this.periodLength = periodLength / (double)schedule.getNumberOfPeriods();
        double[] tenors = new double[initialSwapRates.length];
        for (int index = 0; index < tenors.length; ++index) {
            tenors[index] = schedule.getPeriodStart(index);
        }
        tenors[tenors.length - 1] = schedule.getPeriodEnd(schedule.getNumberOfPeriods() - 1);
        this.rateInterpolator = new RationalFunctionInterpolation(tenors, initialSwapRates, RationalFunctionInterpolation.InterpolationMethod.LINEAR, RationalFunctionInterpolation.ExtrapolationMethod.DEFAULT);
    }

    @Override
    public double getValue(VolatilityCubeModel model, double termination, double maturity, double strike, VolatilitySurface.QuotingConvention quotingConvention) {
        VolatilityCube cube = model.getVolatilityCube(this.referenceCubeName);
        ExponentialCorrelationCurve correlation = new ExponentialCorrelationCurve(this.name, this.referenceDate, this.baseTermination, cube.getCorrelationDecay());
        double value = cube.getValue(model, termination, maturity, strike, quotingConvention);
        value *= correlation.getValue(termination);
        return value *= this.periodLength / (1.0 + this.periodLength * this.rateInterpolator.getValue(termination));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public LocalDate getReferenceDate() {
        return this.referenceDate;
    }

    public String getReferenceCubeName() {
        return this.referenceCubeName;
    }

    public String toString() {
        return super.toString() + "\n\"" + this.getName() + "\"";
    }

    @Override
    public double getValue(double tenorLength, double maturity, double strike, VolatilitySurface.QuotingConvention quotingConvention) {
        return this.getValue(null, tenorLength, maturity, strike, quotingConvention);
    }

    @Override
    public double getCorrelationDecay() {
        throw new UnsupportedOperationException("This VolVolCube does not support a further native correlated cube.");
    }

    @Override
    public Map<String, Object> getParameters() {
        throw new UnsupportedOperationException("This VolVolCube's field cannot be converted to Map<String, Double>");
    }

    @Override
    public double getLowestStrike(VolatilityCubeModel model) {
        return model.getVolatilityCube(this.referenceCubeName).getLowestStrike(model);
    }

    @Override
    public double getIborOisDecorrelation() {
        throw new UnsupportedOperationException("This VolVolCube does not support use of ibor ois decorrelation.");
    }
}

