/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.stochastic;

import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntToDoubleFunction;
import java.util.stream.DoubleStream;
import net.finmath.functions.DoubleTernaryOperator;
import net.finmath.stochastic.RandomVariable;

public class Scalar
implements RandomVariable {
    private static final long serialVersionUID = -729437972787062992L;
    private final double value;

    public Scalar(double value) {
        this.value = value;
    }

    public static Scalar[] arrayOf(double[] arrayOfDoubles) {
        Scalar[] array = new Scalar[arrayOfDoubles.length];
        for (int i = 0; i < arrayOfDoubles.length; ++i) {
            array[i] = new Scalar(arrayOfDoubles[i]);
        }
        return array;
    }

    @Override
    public boolean equals(RandomVariable randomVariable) {
        return randomVariable.isDeterministic() && this.value == randomVariable.get(0);
    }

    @Override
    public double getFiltrationTime() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public int getTypePriority() {
        return 0;
    }

    @Override
    public double get(int pathOrState) {
        return this.value;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public double[] getRealizations() {
        return null;
    }

    @Override
    public Double doubleValue() {
        return this.value;
    }

    @Override
    public IntToDoubleFunction getOperator() {
        return null;
    }

    @Override
    public DoubleStream getRealizationsStream() {
        return null;
    }

    @Override
    public double getMin() {
        return this.value;
    }

    @Override
    public double getMax() {
        return this.value;
    }

    @Override
    public double getAverage() {
        return this.value;
    }

    @Override
    public double getAverage(RandomVariable probabilities) {
        return this.value * probabilities.getAverage();
    }

    @Override
    public double getVariance() {
        return 0.0;
    }

    @Override
    public double getVariance(RandomVariable probabilities) {
        return 0.0;
    }

    @Override
    public double getSampleVariance() {
        return 0.0;
    }

    @Override
    public double getStandardDeviation() {
        return 0.0;
    }

    @Override
    public double getStandardDeviation(RandomVariable probabilities) {
        return 0.0;
    }

    @Override
    public double getStandardError() {
        return 0.0;
    }

    @Override
    public double getStandardError(RandomVariable probabilities) {
        return 0.0;
    }

    @Override
    public double getQuantile(double quantile) {
        return this.value;
    }

    @Override
    public double getQuantile(double quantile, RandomVariable probabilities) {
        return this.value;
    }

    @Override
    public double getQuantileExpectation(double quantileStart, double quantileEnd) {
        return this.value;
    }

    @Override
    public double[] getHistogram(double[] intervalPoints) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double[][] getHistogram(int numberOfPoints, double standardDeviations) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RandomVariable cache() {
        return this;
    }

    @Override
    public RandomVariable apply(DoubleUnaryOperator operator) {
        return new Scalar(operator.applyAsDouble(this.value));
    }

    @Override
    public RandomVariable apply(DoubleBinaryOperator operator, RandomVariable argument) {
        return null;
    }

    @Override
    public RandomVariable apply(DoubleTernaryOperator operator, RandomVariable argument1, RandomVariable argument2) {
        return null;
    }

    @Override
    public RandomVariable cap(double cap) {
        return new Scalar(Math.min(this.value, cap));
    }

    @Override
    public RandomVariable floor(double floor) {
        return new Scalar(Math.max(this.value, floor));
    }

    @Override
    public RandomVariable add(double value) {
        return new Scalar(this.value + value);
    }

    @Override
    public RandomVariable sub(double value) {
        return new Scalar(this.value - value);
    }

    @Override
    public RandomVariable mult(double value) {
        return new Scalar(this.value * value);
    }

    @Override
    public RandomVariable div(double value) {
        return new Scalar(this.value / value);
    }

    @Override
    public RandomVariable pow(double exponent) {
        return new Scalar(Math.pow(this.value, exponent));
    }

    @Override
    public RandomVariable average() {
        return this;
    }

    @Override
    public RandomVariable squared() {
        return new Scalar(this.value * this.value);
    }

    @Override
    public RandomVariable sqrt() {
        return new Scalar(Math.sqrt(this.value));
    }

    @Override
    public RandomVariable exp() {
        return new Scalar(Math.exp(this.value));
    }

    @Override
    public RandomVariable expm1() {
        return new Scalar(Math.expm1(this.value));
    }

    @Override
    public RandomVariable log() {
        return new Scalar(Math.log(this.value));
    }

    @Override
    public RandomVariable sin() {
        return new Scalar(Math.sin(this.value));
    }

    @Override
    public RandomVariable cos() {
        return new Scalar(Math.cos(this.value));
    }

    @Override
    public RandomVariable add(RandomVariable randomVariable) {
        return randomVariable.add(this.value);
    }

    @Override
    public RandomVariable sub(RandomVariable randomVariable) {
        return randomVariable.sub(this.value).mult(-1.0);
    }

    @Override
    public RandomVariable bus(RandomVariable randomVariable) {
        return randomVariable.sub(this.value);
    }

    @Override
    public RandomVariable mult(RandomVariable randomVariable) {
        return randomVariable.mult(this.value);
    }

    @Override
    public RandomVariable div(RandomVariable randomVariable) {
        return randomVariable.invert().mult(this.value);
    }

    @Override
    public RandomVariable vid(RandomVariable randomVariable) {
        return randomVariable.div(this.value);
    }

    @Override
    public RandomVariable cap(RandomVariable cap) {
        return cap.cap(this.value);
    }

    @Override
    public RandomVariable floor(RandomVariable floor) {
        return floor.floor(this.value);
    }

    @Override
    public RandomVariable accrue(RandomVariable rate, double periodLength) {
        return rate.mult(periodLength * this.value).add(this.value);
    }

    @Override
    public RandomVariable discount(RandomVariable rate, double periodLength) {
        if (this.value == 0.0) {
            return rate.mult(0.0);
        }
        return rate.mult(periodLength / this.value).add(1.0 / this.value).invert();
    }

    @Override
    public RandomVariable choose(RandomVariable valueIfTriggerNonNegative, RandomVariable valueIfTriggerNegative) {
        if (this.value >= 0.0) {
            return valueIfTriggerNonNegative;
        }
        return valueIfTriggerNegative;
    }

    @Override
    public RandomVariable invert() {
        return new Scalar(1.0 / this.value);
    }

    @Override
    public RandomVariable abs() {
        return new Scalar(Math.abs(this.value));
    }

    @Override
    public RandomVariable addProduct(RandomVariable factor1, double factor2) {
        return factor1.mult(factor2).add(this.value);
    }

    @Override
    public RandomVariable addProduct(RandomVariable factor1, RandomVariable factor2) {
        return factor1.mult(factor2).add(this.value);
    }

    @Override
    public RandomVariable addRatio(RandomVariable numerator, RandomVariable denominator) {
        return numerator.div(denominator).add(this.value);
    }

    @Override
    public RandomVariable subRatio(RandomVariable numerator, RandomVariable denominator) {
        return numerator.div(denominator).sub(this.value).mult(-1.0);
    }

    @Override
    public RandomVariable isNaN() {
        return new Scalar(Double.isNaN(this.value) ? 1.0 : 0.0);
    }
}

