/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.time;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Iterator;
import net.finmath.time.FloatingpointDate;
import net.finmath.time.Period;
import net.finmath.time.Schedule;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.daycount.DayCountConvention;

public class RegularSchedule
implements Schedule {
    private final TimeDiscretization timeDiscretization;

    public RegularSchedule(TimeDiscretization timeDiscretization) {
        this.timeDiscretization = timeDiscretization;
    }

    @Override
    public LocalDate getReferenceDate() {
        return null;
    }

    public ArrayList<Period> getPeriods() {
        return null;
    }

    @Override
    public DayCountConvention getDaycountconvention() {
        return null;
    }

    @Override
    public int getNumberOfPeriods() {
        return this.timeDiscretization.getNumberOfTimeSteps();
    }

    @Override
    public Period getPeriod(int periodIndex) {
        return null;
    }

    @Override
    public double getFixing(int periodIndex) {
        return this.timeDiscretization.getTime(periodIndex);
    }

    @Override
    public double getPayment(int periodIndex) {
        return this.timeDiscretization.getTime(periodIndex + 1);
    }

    @Override
    public double getPeriodStart(int periodIndex) {
        return this.timeDiscretization.getTime(periodIndex);
    }

    @Override
    public double getPeriodEnd(int periodIndex) {
        return this.timeDiscretization.getTime(periodIndex + 1);
    }

    @Override
    public double getPeriodLength(int periodIndex) {
        return this.timeDiscretization.getTimeStep(periodIndex);
    }

    @Override
    public Iterator<Period> iterator() {
        return null;
    }

    @Override
    public int getPeriodIndex(double time) {
        return this.timeDiscretization.getTimeIndex(time);
    }

    @Override
    public int getPeriodIndex(LocalDate date) {
        double time = FloatingpointDate.getFloatingPointDateFromDate(this.getReferenceDate(), date);
        return this.getPeriodIndex(time);
    }
}

