/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.timeseries;

import java.util.Iterator;
import net.finmath.timeseries.TimeSeries;

public class TimeSeriesView
implements TimeSeries {
    private final TimeSeries timeSeries;
    private final int indexStart;
    private final int indexEnd;

    public TimeSeriesView(TimeSeries timeSeries, int indexStart, int indexEnd) {
        this.timeSeries = timeSeries;
        this.indexStart = indexStart;
        this.indexEnd = indexEnd;
    }

    @Override
    public double getTime(int index) {
        return this.timeSeries.getTime(this.indexStart + index);
    }

    @Override
    public double getValue(int index) {
        return this.timeSeries.getValue(this.indexStart + index);
    }

    @Override
    public int getNumberOfTimePoints() {
        return this.indexEnd - this.indexStart + 1;
    }

    @Override
    public Iterable<Double> getValues() {
        return new Iterable<Double>(){
            private int index = 0;

            @Override
            public Iterator<Double> iterator() {
                return new Iterator<Double>(){

                    @Override
                    public boolean hasNext() {
                        return index < TimeSeriesView.this.getNumberOfTimePoints();
                    }

                    @Override
                    public Double next() {
                        return TimeSeriesView.this.getValue(index++);
                    }
                };
            }
        };
    }
}

