/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.flow.diff;

import java.util.LinkedList;
import net.fortytwo.flow.Sink;
import net.fortytwo.flow.diff.DiffSink;
import net.fortytwo.flow.diff.DiffSource;
import net.fortytwo.ripple.RippleException;

public class Diff<T>
implements DiffSink<T>,
DiffSource<T> {
    private final LinkedList<Change> changes = new LinkedList();
    private final Sink<T> plusSink = new Sink<T>(){

        @Override
        public void put(T t) throws RippleException {
            Change ch = new Change();
            ch.value = t;
            ch.action = Action.Add;
            Diff.this.changes.addLast(ch);
        }
    };
    private final Sink<T> minusSink = new Sink<T>(){

        @Override
        public void put(T t) throws RippleException {
            Change ch = new Change();
            ch.value = t;
            ch.action = Action.Remove;
            Diff.this.changes.addLast(ch);
        }
    };

    @Override
    public Sink<T> getPlus() {
        return this.plusSink;
    }

    @Override
    public Sink<T> getMinus() {
        return this.minusSink;
    }

    public void clear() {
        this.changes.clear();
    }

    public int size() {
        return this.changes.size();
    }

    @Override
    public void writeTo(DiffSink<T> sink) throws RippleException {
        Sink otherPlusSink = sink.getPlus();
        Sink otherMinusSink = sink.getMinus();
        block4: for (Change ch : this.changes) {
            switch (ch.action) {
                case Add: {
                    otherPlusSink.put(ch.value);
                    continue block4;
                }
                case Remove: {
                    otherMinusSink.put(ch.value);
                    continue block4;
                }
            }
            System.err.println("unsupported Action: " + (Object)((Object)ch.action));
        }
    }

    private class Change {
        public T value;
        public Action action;

        private Change() {
        }
    }

    private static enum Action {
        Add,
        Remove;

    }
}

