/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.sdk.alipay.config;

import com.alipay.api.AlipayClient;
import com.alipay.api.DefaultAlipayClient;
import net.guerlab.sdk.alipay.config.AlipayConfig;
import net.guerlab.sdk.alipay.config.AlipayUrlConstants;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={AlipayConfig.class})
public class ApilayAutoConfiguration {
    @Bean
    public AlipayClient client(AlipayConfig config) {
        String signType = "RSA".equals(config.getSignType()) ? "RSA" : "RSA2";
        DefaultAlipayClient client = new DefaultAlipayClient(AlipayUrlConstants.gateway(config.isDev()), config.getAppId(), config.getPrivateKey(), "json", "UTF-8", config.getAlipayPublicKey(), signType);
        return client;
    }
}

