/*
 * Decompiled with CFR 0.152.
 */
package net.iakovlev.timeshape;

import java.time.ZoneId;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.iakovlev.timeshape.Index;

public final class SameZoneSpan {
    private final Set<ZoneId> zoneIds;
    private final int endIndex;

    public Set<ZoneId> getZoneIds() {
        return new HashSet<ZoneId>(this.zoneIds);
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public int hashCode() {
        return Objects.hash(this.zoneIds, this.endIndex);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SameZoneSpan)) {
            return false;
        }
        SameZoneSpan sameZoneSpan = (SameZoneSpan)object;
        return sameZoneSpan.endIndex == this.endIndex && sameZoneSpan.zoneIds.equals(this.zoneIds);
    }

    public String toString() {
        return String.format("%s: end index %d", this.zoneIds, this.endIndex);
    }

    SameZoneSpan(Set<ZoneId> set, int n) {
        this.zoneIds = new HashSet<ZoneId>(set);
        this.endIndex = n;
    }

    static SameZoneSpan fromIndexEntries(List<Index.Entry> list, int n) {
        return new SameZoneSpan(list.stream().map(entry -> entry.zoneId).collect(Collectors.toSet()), n);
    }
}

