/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.tools.xjc.plugin.fluent_api;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPrimitiveType;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jvnet.jaxb2_commons.tools.xjc.plugin.fluent_api.FluentMethodInfo;
import org.jvnet.jaxb2_commons.tools.xjc.plugin.fluent_api.FluentMethodType;
import org.xml.sax.ErrorHandler;

public class XjcFluentApiPlugin
extends Plugin {
    public String getOptionName() {
        return "Xfluent-api";
    }

    public String getUsage() {
        return "  -Xfluent-api        :  enable fluent api for generated code";
    }

    public boolean run(Outline outline, Options opt, ErrorHandler errorHandler) {
        JPrimitiveType voidType = outline.getCodeModel().VOID;
        for (ClassOutline classOutline : outline.getClasses()) {
            JDefinedClass targetImplClass = classOutline.implClass;
            ArrayList<FluentMethodInfo> fluentMethodInfoList = new ArrayList<FluentMethodInfo>();
            HashSet<String> methodNames = new HashSet<String>();
            boolean isOverride = false;
            while (true) {
                JDefinedClass implClass = classOutline.implClass;
                for (JMethod jmethod : implClass.methods()) {
                    if (methodNames.contains(jmethod.name())) continue;
                    if (this.isSetterMethod(jmethod, (JType)voidType)) {
                        fluentMethodInfoList.add(new FluentMethodInfo(jmethod, FluentMethodType.FLUENT_SETTER, isOverride));
                        methodNames.add(jmethod.name());
                        continue;
                    }
                    if (!this.isListGetterMethod(jmethod)) continue;
                    fluentMethodInfoList.add(new FluentMethodInfo(jmethod, FluentMethodType.FLUENT_LIST_SETTER, isOverride));
                    fluentMethodInfoList.add(new FluentMethodInfo(jmethod, FluentMethodType.FLUENT_COLLECTION_SETTER, isOverride));
                    methodNames.add(jmethod.name());
                }
                if ((classOutline = classOutline.getSuperClass()) == null) break;
                isOverride = true;
            }
            for (FluentMethodInfo fluentMethodInfo : fluentMethodInfoList) {
                fluentMethodInfo.createFluentMethod(targetImplClass);
            }
        }
        return true;
    }

    private boolean isSetterMethod(JMethod jmethod, JType VOID) {
        if (jmethod.type() == VOID) {
            JVar[] jvars = jmethod.listParams();
            switch (jvars.length) {
                case 2: {
                    if (!this.isInt(jvars[0].type())) {
                        return false;
                    }
                }
                case 1: {
                    int mods = jmethod.mods().getValue();
                    if ((mods & 0x10) != 0 || (mods & 1) != 1) break;
                    String methodName = jmethod.name();
                    return methodName.length() > FluentMethodType.SETTER_METHOD_PREFIX_LEN && methodName.startsWith("set");
                }
            }
        }
        return false;
    }

    private boolean isListGetterMethod(JMethod jmethod) {
        int mods = jmethod.mods().getValue();
        if ((mods & 0x10) == 1 || (mods & 1) == 0) {
            return false;
        }
        String methodName = jmethod.name();
        if (methodName.length() <= FluentMethodType.GETTER_METHOD_PREFIX_LEN || !methodName.startsWith("get")) {
            return false;
        }
        if (jmethod.listParams().length > 0) {
            return false;
        }
        JType jtype = jmethod.type();
        if (jtype instanceof JClass) {
            JClass jclass = (JClass)JClass.class.cast(jtype);
            List typeParams = jclass.getTypeParameters();
            if (typeParams.size() != 1) {
                return false;
            }
            return jclass.fullName().startsWith(FluentMethodType.PARAMETERIZED_LIST_PREFIX);
        }
        return false;
    }

    private boolean isInt(JType type) {
        JCodeModel codeModel = type.owner();
        return type.isPrimitive() && codeModel.INT.equals(JType.parse((JCodeModel)codeModel, (String)type.name()));
    }
}

