/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.jqwik.api.JqwikException;
import net.jqwik.api.lifecycle.CannotResolveParameterException;
import net.jqwik.api.lifecycle.ContainerLifecycleContext;
import net.jqwik.api.lifecycle.ProvidePropertyInstanceHook;
import net.jqwik.engine.descriptor.ContainerClassDescriptor;
import net.jqwik.engine.execution.lifecycle.ContainerInstances;
import net.jqwik.engine.support.JqwikExceptionSupport;
import net.jqwik.engine.support.JqwikReflectionSupport;
import org.jspecify.annotations.Nullable;
import org.junit.platform.engine.TestDescriptor;

class ContainerInstancesCreator {
    private final ContainerLifecycleContext containerLifecycleContext;
    private final Class<?> containerClass;
    private final ContainerClassDescriptor containerDescriptor;
    private final ProvidePropertyInstanceHook providePropertyInstance;

    ContainerInstancesCreator(ContainerLifecycleContext containerLifecycleContext, ContainerClassDescriptor containerDescriptor, ProvidePropertyInstanceHook providePropertyInstanceHook) {
        this.containerLifecycleContext = containerLifecycleContext;
        this.containerClass = (Class)containerLifecycleContext.optionalContainerClass().orElseThrow(() -> {
            String message = String.format("Container [%s] cannot be instantiated", containerLifecycleContext.label());
            return new JqwikException(message);
        });
        this.containerDescriptor = containerDescriptor;
        this.providePropertyInstance = providePropertyInstanceHook;
    }

    ContainerInstances create() {
        if (this.providePropertyInstance.equals((Object)ProvidePropertyInstanceHook.DEFAULT)) {
            return this.createInstances(this.containerClass, this.containerDescriptor);
        }
        try {
            return new ContainerInstances(this.providePropertyInstance.provide(this.containerClass));
        }
        catch (Throwable throwable) {
            JqwikExceptionSupport.rethrowIfBlacklisted(throwable);
            String message = String.format("ProvidePropertyInstanceHook [%s] cannot provide instance for class [%s]", this.providePropertyInstance, this.containerClass);
            throw new JqwikException(message, throwable);
        }
    }

    private ContainerInstances createInstances(Class<?> targetClass, TestDescriptor descriptor) {
        List<Constructor<?>> constructors = this.allAccessibleConstructors(targetClass);
        if (constructors.size() == 0) {
            String message = String.format("Test container class [%s] has no accessible constructor", targetClass.getName());
            throw new JqwikException(message);
        }
        if (constructors.size() > 1) {
            String message = String.format("Test container class [%s] has more than one accessible constructor", targetClass.getName());
            throw new JqwikException(message);
        }
        Constructor<?> constructor = constructors.get(0);
        return this.newInstances(targetClass, constructor, descriptor);
    }

    private ContainerInstances newInstances(Class<?> targetClass, Constructor<?> constructor, TestDescriptor descriptor) {
        if (JqwikReflectionSupport.isInnerClass(targetClass)) {
            return this.newInstancesOfInnerContainer(constructor, descriptor);
        }
        return this.newInstancesOfBaseContainer(constructor);
    }

    private ContainerInstances newInstancesOfBaseContainer(Constructor<?> constructor) {
        return new ContainerInstances(this.createNewInstance(constructor, null));
    }

    private Object createNewInstance(Constructor<?> constructor, @Nullable Object outerInstance) {
        return JqwikReflectionSupport.newInstance(constructor, this.resolveConstructorParameters(constructor, outerInstance));
    }

    private ContainerInstances newInstancesOfInnerContainer(Constructor<?> constructor, TestDescriptor descriptor) {
        TestDescriptor parentDescriptor = descriptor.getParent().orElse(descriptor);
        ContainerClassDescriptor parentClassDescriptor = (ContainerClassDescriptor)parentDescriptor;
        Class<?> parentClass = parentClassDescriptor.getContainerClass();
        ContainerInstances parentInstances = this.createInstances(parentClass, parentDescriptor);
        return new ContainerInstances(this.createNewInstance(constructor, parentInstances.target()), parentInstances);
    }

    private List<Constructor<?>> allAccessibleConstructors(Class<?> instanceClass) {
        ArrayList constructors = new ArrayList(Arrays.asList(instanceClass.getConstructors()));
        for (Constructor<?> declaredConstructor : instanceClass.getDeclaredConstructors()) {
            if (constructors.contains(declaredConstructor)) continue;
            constructors.add(declaredConstructor);
        }
        return constructors;
    }

    private Object[] resolveConstructorParameters(Constructor<?> constructor, @Nullable Object outerInstance) {
        Object[] args = new Object[constructor.getParameterCount()];
        for (int i = 0; i < args.length; ++i) {
            int index = i;
            args[index] = index == 0 && outerInstance != null ? outerInstance : this.containerLifecycleContext.resolveParameter(constructor, index).map(parameterSupplier -> parameterSupplier.get(Optional.empty())).orElseThrow(() -> {
                String info = "No matching resolver could be found";
                return new CannotResolveParameterException(constructor.getParameters()[index], info);
            });
        }
        return args;
    }
}

