/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import net.jqwik.api.Reporter;
import net.jqwik.api.lifecycle.PropertyAttributes;
import net.jqwik.api.lifecycle.PropertyLifecycleContext;
import net.jqwik.api.lifecycle.ResolveParameterHook;
import net.jqwik.engine.descriptor.PropertyMethodDescriptor;
import net.jqwik.engine.execution.AbstractLifecycleContext;
import net.jqwik.engine.execution.ParameterSupplierResolver;
import net.jqwik.engine.execution.lifecycle.ContainerInstances;
import net.jqwik.engine.support.JqwikReflectionSupport;

public class DefaultPropertyLifecycleContext
extends AbstractLifecycleContext
implements PropertyLifecycleContext {
    private final PropertyMethodDescriptor methodDescriptor;
    private final ContainerInstances testInstances;
    private final ParameterSupplierResolver parameterSupplierResolver;

    public DefaultPropertyLifecycleContext(PropertyMethodDescriptor methodDescriptor, Object testInstance, Reporter reporter, ResolveParameterHook resolveParameterHook) {
        this(methodDescriptor, new ContainerInstances(testInstance), reporter, resolveParameterHook);
    }

    public DefaultPropertyLifecycleContext(PropertyMethodDescriptor methodDescriptor, ContainerInstances testInstances, Reporter reporter, ResolveParameterHook resolveParameterHook) {
        super(reporter, methodDescriptor);
        this.parameterSupplierResolver = new ParameterSupplierResolver(resolveParameterHook, this);
        this.methodDescriptor = methodDescriptor;
        this.testInstances = testInstances;
    }

    public Method targetMethod() {
        return this.methodDescriptor.getTargetMethod();
    }

    public Class<?> containerClass() {
        return this.methodDescriptor.getContainerClass();
    }

    public Optional<AnnotatedElement> optionalElement() {
        return Optional.of(this.targetMethod());
    }

    public Optional<Class<?>> optionalContainerClass() {
        return Optional.of(this.containerClass());
    }

    public Object testInstance() {
        return this.testInstances.target();
    }

    public List<Object> testInstances() {
        return this.testInstances.all();
    }

    public String extendedLabel() {
        return this.methodDescriptor.extendedLabel();
    }

    public <T> T newInstance(Class<T> clazz) {
        return JqwikReflectionSupport.newInstanceInTestContext(clazz, this.testInstance());
    }

    public Optional<ResolveParameterHook.ParameterSupplier> resolveParameter(Executable executable, int index) {
        return this.parameterSupplierResolver.resolveParameter(executable, index, this.containerClass());
    }

    public PropertyAttributes attributes() {
        return this.methodDescriptor.getConfiguration().getPropertyAttributes();
    }

    public String toString() {
        return this.toString(PropertyLifecycleContext.class);
    }
}

