/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.jqwik.api.ForAll;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.lifecycle.CannotResolveParameterException;
import net.jqwik.api.lifecycle.LifecycleContext;
import net.jqwik.api.lifecycle.PropertyLifecycleContext;
import net.jqwik.api.lifecycle.ResolveParameterHook;
import net.jqwik.api.lifecycle.TryLifecycleContext;
import net.jqwik.engine.execution.DefaultParameterInjectionContext;
import net.jqwik.engine.execution.GenerationInfo;
import net.jqwik.engine.execution.ParameterSupplierResolver;
import net.jqwik.engine.execution.ParametersGenerator;
import net.jqwik.engine.execution.ShrinkableResolvedParameter;
import net.jqwik.engine.properties.ForAllParametersGenerator;
import net.jqwik.engine.support.MethodParameter;

public class ResolvingParametersGenerator
implements ParametersGenerator {
    private final List<MethodParameter> propertyParameters;
    private final ForAllParametersGenerator forAllParametersGenerator;
    private final ParameterSupplierResolver parameterSupplierResolver;
    private int currentGenerationIndex = 0;

    public ResolvingParametersGenerator(List<MethodParameter> propertyParameters, ForAllParametersGenerator forAllParametersGenerator, ResolveParameterHook resolveParameterHook, PropertyLifecycleContext propertyLifecycleContext) {
        this.propertyParameters = propertyParameters;
        this.forAllParametersGenerator = forAllParametersGenerator;
        this.parameterSupplierResolver = new ParameterSupplierResolver(resolveParameterHook, (LifecycleContext)propertyLifecycleContext);
    }

    @Override
    public boolean hasNext() {
        return this.forAllParametersGenerator.hasNext();
    }

    @Override
    public List<Shrinkable<Object>> next(TryLifecycleContext context) {
        ArrayList<Shrinkable<Object>> next = new ArrayList<Shrinkable<Object>>();
        ArrayList forAllShrinkables = new ArrayList((Collection)this.forAllParametersGenerator.next());
        for (MethodParameter parameter : this.propertyParameters) {
            if (parameter.isAnnotated(ForAll.class)) {
                next.add((Shrinkable<Object>)((Shrinkable)forAllShrinkables.get(0)));
                forAllShrinkables.remove(0);
                continue;
            }
            next.add(this.findResolvableParameter(parameter, context));
        }
        ++this.currentGenerationIndex;
        return next;
    }

    @Override
    public int edgeCasesTotal() {
        return this.forAllParametersGenerator.edgeCasesTotal();
    }

    @Override
    public int edgeCasesTried() {
        return this.forAllParametersGenerator.edgeCasesTried();
    }

    @Override
    public GenerationInfo generationInfo(String randomSeed) {
        return new GenerationInfo(randomSeed, this.currentGenerationIndex);
    }

    private Shrinkable<Object> findResolvableParameter(MethodParameter parameter, TryLifecycleContext tryLifecycleContext) {
        ResolveParameterHook.ParameterSupplier parameterSupplier = this.parameterSupplierResolver.resolveParameter(parameter).orElseThrow(() -> {
            String info = "No matching resolver could be found";
            return new CannotResolveParameterException(parameter.getRawParameter(), info);
        });
        DefaultParameterInjectionContext parameterContext = new DefaultParameterInjectionContext(parameter);
        return new ShrinkableResolvedParameter(parameterSupplier, parameterContext, tryLifecycleContext);
    }

    @Override
    public void reset() {
        this.currentGenerationIndex = 0;
        this.forAllParametersGenerator.reset();
    }
}

