/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution.lifecycle;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import net.jqwik.api.lifecycle.AddLifecycleHook;
import net.jqwik.api.lifecycle.LifecycleHook;
import net.jqwik.engine.descriptor.ContainerClassDescriptor;
import net.jqwik.engine.descriptor.PropertyMethodDescriptor;
import net.jqwik.engine.execution.lifecycle.LifecycleHooksRegistry;
import net.jqwik.engine.execution.lifecycle.RegisteredLifecycleHooks;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.TestDescriptor;

public class JqwikLifecycleRegistrator {
    private final LifecycleHooksRegistry lifecycleRegistry;

    public JqwikLifecycleRegistrator(LifecycleHooksRegistry lifecycleRegistry, ConfigurationParameters configurationParameters) {
        this.lifecycleRegistry = lifecycleRegistry;
    }

    public void registerLifecycleHooks(TestDescriptor rootDescriptor) {
        this.registerGlobalHooks(rootDescriptor);
        this.register(rootDescriptor);
    }

    private void registerGlobalHooks(TestDescriptor rootDescriptor) {
        for (LifecycleHook lifecycleHook : RegisteredLifecycleHooks.getRegisteredHooks()) {
            this.lifecycleRegistry.registerLifecycleInstance(rootDescriptor, lifecycleHook);
        }
    }

    private void register(TestDescriptor descriptor) {
        if (descriptor instanceof PropertyMethodDescriptor) {
            this.registerPropertyMethodHooks((PropertyMethodDescriptor)descriptor);
        }
        if (descriptor instanceof ContainerClassDescriptor) {
            this.registerContainerHooks((ContainerClassDescriptor)descriptor);
        }
        for (TestDescriptor childDescriptor : descriptor.getChildren()) {
            this.register(childDescriptor);
        }
    }

    private void registerContainerHooks(ContainerClassDescriptor containerClassDescriptor) {
        Class<?> containerClass = containerClassDescriptor.getContainerClass();
        this.registerHooks(containerClassDescriptor, containerClass);
    }

    private void registerPropertyMethodHooks(PropertyMethodDescriptor propertyMethodDescriptor) {
        Method targetMethod = propertyMethodDescriptor.getTargetMethod();
        this.registerHooks(propertyMethodDescriptor, targetMethod);
    }

    private void registerHooks(TestDescriptor descriptor, AnnotatedElement element) {
        List addLifecycleHooks = AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)element, AddLifecycleHook.class);
        for (AddLifecycleHook addLifecycleHook : addLifecycleHooks) {
            this.lifecycleRegistry.registerLifecycleHook(descriptor, addLifecycleHook.value(), addLifecycleHook.propagateTo());
        }
    }
}

