/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution.pipeline;

import java.util.function.BiFunction;
import net.jqwik.engine.execution.PropertyExecutionListener;
import net.jqwik.engine.execution.lifecycle.CurrentTestDescriptor;
import net.jqwik.engine.execution.pipeline.TaskExecutionResult;
import net.jqwik.engine.support.JqwikExceptionSupport;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;

public interface ExecutionTask {
    public UniqueId ownerId();

    public TaskExecutionResult execute(PropertyExecutionListener var1, TaskExecutionResult var2);

    public static ExecutionTask from(final BiFunction<PropertyExecutionListener, TaskExecutionResult, TaskExecutionResult> executor, final TestDescriptor owner, final String description) {
        return new ExecutionTask(){

            @Override
            public UniqueId ownerId() {
                return owner.getUniqueId();
            }

            @Override
            public TaskExecutionResult execute(PropertyExecutionListener listener, TaskExecutionResult predecessorResult) {
                try {
                    return CurrentTestDescriptor.runWithDescriptor(owner, () -> (TaskExecutionResult)executor.apply(listener, predecessorResult));
                }
                catch (Throwable throwable) {
                    JqwikExceptionSupport.rethrowIfBlacklisted(throwable);
                    return TaskExecutionResult.failure(throwable);
                }
            }

            public String toString() {
                return "ExecutionTask: " + description;
            }
        };
    }
}

