/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution.reporting;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.jqwik.engine.execution.reporting.LineReporter;
import net.jqwik.engine.execution.reporting.ValueReport;

class TupleValueReport
extends ValueReport {
    private static final int MAX_LINE_LENGTH = 100;
    private final List<ValueReport> tupleReports;

    TupleValueReport(Optional<String> label, List<ValueReport> tupleReports) {
        super(label);
        this.tupleReports = tupleReports;
    }

    @Override
    public String singleLineReport() {
        return this.label.orElse("") + "(" + this.singleLineReports() + ")";
    }

    private String singleLineReports() {
        return this.tupleReports.stream().map(this::singleLineReport).collect(Collectors.joining(", "));
    }

    private String singleLineReport(ValueReport report) {
        return report.singleLineReport();
    }

    @Override
    public void report(LineReporter lineReporter, int indentLevel, String appendix) {
        lineReporter.addLine(indentLevel, this.label.orElse("") + "(");
        this.reportTupleReports(lineReporter, indentLevel + 1);
        lineReporter.addLine(indentLevel, ")" + appendix);
    }

    private void reportTupleReports(LineReporter lineReporter, int indentLevel) {
        for (int i = 0; i < this.tupleReports.size(); ++i) {
            boolean isNotLast = i < this.tupleReports.size() - 1;
            ValueReport reportEntry = this.tupleReports.get(i);
            String optionalComma = isNotLast ? ", " : "";
            String singleLineEntry = this.singleLineReport(reportEntry);
            if (singleLineEntry.length() + indentLevel * 2 <= 100) {
                lineReporter.addLine(indentLevel, singleLineEntry + optionalComma);
                continue;
            }
            reportEntry.report(lineReporter, indentLevel, optionalComma);
        }
    }
}

