/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties;

import java.util.function.Consumer;
import java.util.function.Function;
import net.jqwik.api.support.HashCodeSupport;

public class Range<T extends Comparable<T>> {
    public final T min;
    public final boolean minIncluded;
    public final T max;
    public final boolean maxIncluded;

    public static <T extends Comparable<T>> Range<T> of(T min, T max) {
        return Range.of(min, true, max, true);
    }

    public static <T extends Comparable<T>> Range<T> of(T min, boolean minIncluded, T max, boolean maxIncluded) {
        if (min.compareTo(max) > 0) {
            throw new IllegalArgumentException(String.format("Min value [%s] must not be greater than max value [%s].", min, max));
        }
        if (!(min.compareTo(max) != 0 || minIncluded && maxIncluded)) {
            throw new IllegalArgumentException(String.format("If min value [%s] is equal to max value [%s] borders must be included.", min, max));
        }
        return new Range<T>(min, minIncluded, max, maxIncluded);
    }

    private Range(T min, boolean minIncluded, T max, boolean maxIncluded) {
        this.min = min;
        this.minIncluded = minIncluded;
        this.max = max;
        this.maxIncluded = maxIncluded;
    }

    public boolean isSingular() {
        return this.min.compareTo(this.max) == 0 && this.minIncluded && this.maxIncluded;
    }

    public boolean includes(T value) {
        int minCompare = value.compareTo(this.min);
        int maxCompare = value.compareTo(this.max);
        if (minCompare < 0 || maxCompare > 0) {
            return false;
        }
        if (!this.minIncluded && minCompare == 0) {
            return false;
        }
        return this.maxIncluded || maxCompare != 0;
    }

    public void ifIncluded(T value, Consumer<T> consumer) {
        if (this.includes(value)) {
            consumer.accept(value);
        }
    }

    public <U extends Comparable<U>> Range<U> map(Function<T, U> mapper) {
        return Range.of((Comparable)mapper.apply(this.min), this.minIncluded, (Comparable)mapper.apply(this.max), this.maxIncluded);
    }

    public Range<T> withMin(T newMin, boolean newMinIncluded) {
        return Range.of(newMin, newMinIncluded, this.max, this.maxIncluded);
    }

    public Range<T> withMax(T newMax, boolean newMaxIncluded) {
        return Range.of(this.min, this.minIncluded, newMax, newMaxIncluded);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Range range = (Range)o;
        if (this.minIncluded != range.minIncluded) {
            return false;
        }
        if (this.maxIncluded != range.maxIncluded) {
            return false;
        }
        if (!this.min.equals(range.min)) {
            return false;
        }
        return this.max.equals(range.max);
    }

    public int hashCode() {
        return HashCodeSupport.hash(this.min, (Object)this.minIncluded, this.max, (Object)this.maxIncluded);
    }

    public String toString() {
        char leftBracket = this.minIncluded ? (char)'[' : ']';
        char rightBracket = this.maxIncluded ? (char)']' : '[';
        return String.format("%s%s..%s%s", Character.valueOf(leftBracket), this.min, this.max, Character.valueOf(rightBracket));
    }
}

