/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.math.BigInteger;
import java.util.Optional;
import java.util.function.Consumer;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomDistribution;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.arbitraries.IntegerArbitrary;
import net.jqwik.engine.properties.arbitraries.EdgeCasesSupport;
import net.jqwik.engine.properties.arbitraries.IntegralGeneratingArbitrary;
import net.jqwik.engine.properties.arbitraries.MappedEdgeCasesConsumer;
import net.jqwik.engine.properties.arbitraries.TypedCloneable;

public class DefaultIntegerArbitrary
extends TypedCloneable
implements IntegerArbitrary {
    private static final int DEFAULT_MIN = Integer.MIN_VALUE;
    private static final int DEFAULT_MAX = Integer.MAX_VALUE;
    private IntegralGeneratingArbitrary generatingArbitrary = new IntegralGeneratingArbitrary(BigInteger.valueOf(Integer.MIN_VALUE), BigInteger.valueOf(Integer.MAX_VALUE));

    public RandomGenerator<Integer> generator(int genSize) {
        return this.generatingArbitrary.generator(genSize).map(BigInteger::intValueExact);
    }

    public Optional<ExhaustiveGenerator<Integer>> exhaustive(long maxNumberOfSamples) {
        return this.generatingArbitrary.exhaustive(maxNumberOfSamples).map(generator -> generator.map(BigInteger::intValueExact));
    }

    public EdgeCases<Integer> edgeCases(int maxEdgeCases) {
        return EdgeCasesSupport.map(this.generatingArbitrary.edgeCases(maxEdgeCases), BigInteger::intValueExact);
    }

    public Arbitrary<Integer> edgeCases(Consumer<EdgeCases.Config<Integer>> configurator) {
        MappedEdgeCasesConsumer<Integer, BigInteger> integralConfigurator = new MappedEdgeCasesConsumer<Integer, BigInteger>(configurator, BigInteger::intValueExact, BigInteger::valueOf);
        DefaultIntegerArbitrary clone = (DefaultIntegerArbitrary)this.typedClone();
        clone.generatingArbitrary = (IntegralGeneratingArbitrary)this.generatingArbitrary.edgeCases(integralConfigurator);
        return clone;
    }

    public IntegerArbitrary withDistribution(RandomDistribution distribution) {
        DefaultIntegerArbitrary clone = (DefaultIntegerArbitrary)this.typedClone();
        clone.generatingArbitrary.distribution = distribution;
        return clone;
    }

    public IntegerArbitrary greaterOrEqual(int min) {
        DefaultIntegerArbitrary clone = (DefaultIntegerArbitrary)this.typedClone();
        clone.generatingArbitrary.min = BigInteger.valueOf(min);
        return clone;
    }

    public IntegerArbitrary lessOrEqual(int max) {
        DefaultIntegerArbitrary clone = (DefaultIntegerArbitrary)this.typedClone();
        clone.generatingArbitrary.max = BigInteger.valueOf(max);
        return clone;
    }

    public IntegerArbitrary shrinkTowards(int target) {
        DefaultIntegerArbitrary clone = (DefaultIntegerArbitrary)this.typedClone();
        clone.generatingArbitrary.shrinkingTarget = BigInteger.valueOf(target);
        return clone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultIntegerArbitrary that = (DefaultIntegerArbitrary)o;
        return this.generatingArbitrary.equals(that.generatingArbitrary);
    }

    public int hashCode() {
        return this.generatingArbitrary.hashCode();
    }
}

