/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.randomized;

import java.math.BigInteger;
import net.jqwik.api.RandomDistribution;
import net.jqwik.engine.properties.arbitraries.randomized.BigUniformNumericGenerator;
import net.jqwik.engine.properties.arbitraries.randomized.SmallUniformNumericGenerator;

public class UniformRandomDistribution
implements RandomDistribution {
    public RandomDistribution.RandomNumericGenerator createGenerator(int genSize, BigInteger min, BigInteger max, BigInteger center) {
        if (UniformRandomDistribution.isWithinIntegerRange(min, max)) {
            return new SmallUniformNumericGenerator(min, max);
        }
        return new BigUniformNumericGenerator(min, max);
    }

    private static boolean isWithinIntegerRange(BigInteger min, BigInteger max) {
        boolean rangeIsSmallerThanIntegerMax = max.subtract(min).compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) < 0;
        boolean minAndMaxAreWithinInt = min.compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) >= 0 && max.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) <= 0;
        return rangeIsSmallerThanIntegerMax && minAndMaxAreWithinInt;
    }

    public String toString() {
        return "UniformDistribution";
    }
}

