/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.configurators;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.arbitraries.BigDecimalArbitrary;
import net.jqwik.api.arbitraries.BigIntegerArbitrary;
import net.jqwik.api.arbitraries.ByteArbitrary;
import net.jqwik.api.arbitraries.DoubleArbitrary;
import net.jqwik.api.arbitraries.FloatArbitrary;
import net.jqwik.api.arbitraries.IntegerArbitrary;
import net.jqwik.api.arbitraries.LongArbitrary;
import net.jqwik.api.arbitraries.ShortArbitrary;
import net.jqwik.api.configurators.ArbitraryConfiguratorBase;
import net.jqwik.api.constraints.Positive;

public class PositiveConfigurator
extends ArbitraryConfiguratorBase {
    public Arbitrary<BigDecimal> configure(BigDecimalArbitrary arbitrary, Positive positive) {
        return arbitrary.greaterOrEqual(BigDecimal.ZERO).filter(value -> value.compareTo(BigDecimal.ZERO) > 0);
    }

    public BigIntegerArbitrary configure(BigIntegerArbitrary arbitrary, Positive positive) {
        return arbitrary.greaterOrEqual(BigInteger.ONE);
    }

    public ByteArbitrary configure(ByteArbitrary arbitrary, Positive positive) {
        return arbitrary.greaterOrEqual((byte)1);
    }

    public Arbitrary<Double> configure(DoubleArbitrary arbitrary, Positive positive) {
        return arbitrary.greaterOrEqual(0.0).filter(value -> value > 0.0);
    }

    public Arbitrary<Float> configure(FloatArbitrary arbitrary, Positive positive) {
        return arbitrary.greaterOrEqual(0.0f).filter(value -> value.floatValue() > 0.0f);
    }

    public IntegerArbitrary configure(IntegerArbitrary arbitrary, Positive positive) {
        return arbitrary.greaterOrEqual(1);
    }

    public LongArbitrary configure(LongArbitrary arbitrary, Positive positive) {
        return arbitrary.greaterOrEqual(1L);
    }

    public ShortArbitrary configure(ShortArbitrary arbitrary, Positive positive) {
        return arbitrary.greaterOrEqual((short)1);
    }
}

