/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.math.BigInteger;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Stream;

public class BigIntegerShrinker {
    private final BigInteger shrinkingTarget;

    public BigIntegerShrinker(BigInteger shrinkingTarget) {
        this.shrinkingTarget = shrinkingTarget;
    }

    public Stream<BigInteger> shrink(BigInteger value) {
        LinkedHashSet<BigInteger> candidates = new LinkedHashSet<BigInteger>();
        BigInteger lower = this.shrinkingTarget.min(value);
        BigInteger higher = this.shrinkingTarget.max(value);
        this.addFibbonaci(candidates, lower, BigInteger.valueOf(0L), BigInteger.valueOf(1L), higher);
        this.subFibbonaci(candidates, higher, BigInteger.valueOf(0L), BigInteger.valueOf(1L), lower);
        candidates.add(this.shrinkingTarget);
        candidates.remove(value);
        return candidates.stream();
    }

    private void subFibbonaci(Set<BigInteger> candidates, BigInteger target, BigInteger butLast, BigInteger last, BigInteger border) {
        BigInteger step;
        BigInteger candidate;
        while ((candidate = target.subtract(step = butLast.add(last))).compareTo(border) > 0) {
            candidates.add(candidate);
            butLast = last;
            last = step;
        }
    }

    private void addFibbonaci(Set<BigInteger> candidates, BigInteger target, BigInteger butLast, BigInteger last, BigInteger border) {
        BigInteger step;
        BigInteger candidate;
        while ((candidate = target.add(step = butLast.add(last))).compareTo(border) < 0) {
            candidates.add(candidate);
            butLast = last;
            last = step;
        }
    }
}

