/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.ShrinkingDistance;
import net.jqwik.engine.properties.shrinking.ShrinkingCommons;
import net.jqwik.engine.support.JqwikStreamSupport;

public class CollectShrinkable<T>
implements Shrinkable<List<T>> {
    private final List<? extends Shrinkable<T>> elements;
    private final Predicate<? super List<? extends T>> until;

    public CollectShrinkable(List<? extends Shrinkable<T>> elements, Predicate<? super List<? extends T>> until) {
        this.elements = elements;
        this.until = until;
    }

    public List<T> value() {
        return this.createValue(this.elements);
    }

    private List<T> createValue(List<? extends Shrinkable<T>> elements) {
        return elements.stream().map(Shrinkable::value).collect(Collectors.toList());
    }

    public Stream<Shrinkable<List<T>>> shrink() {
        return JqwikStreamSupport.concat(this.shrinkElementsOneAfterTheOther(), this.sortElements()).filter(s -> this.until.test((List<Object>)s.value()));
    }

    private Stream<Shrinkable<List<T>>> shrinkElementsOneAfterTheOther() {
        ArrayList shrinkPerPartStreams = new ArrayList();
        for (int i = 0; i < this.elements.size(); ++i) {
            int index = i;
            Shrinkable<T> part = this.elements.get(i);
            Stream shrinkElement = part.shrink().flatMap(shrunkElement -> {
                Optional<List<Shrinkable<List>>> shrunkCollection = this.collectElements(index, (Shrinkable<T>)shrunkElement);
                return shrunkCollection.map(shrunkElements -> Stream.of(this.createShrinkable((List<? extends Shrinkable<T>>)shrunkElements))).orElse(Stream.empty());
            });
            shrinkPerPartStreams.add(shrinkElement);
        }
        return JqwikStreamSupport.concat(shrinkPerPartStreams);
    }

    private Stream<Shrinkable<List<T>>> sortElements() {
        return ShrinkingCommons.sortElements(this.elements, this::createShrinkable);
    }

    private CollectShrinkable<T> createShrinkable(List<? extends Shrinkable<T>> pairSwap) {
        return new CollectShrinkable<T>(pairSwap, this.until);
    }

    private Optional<List<Shrinkable<T>>> collectElements(int replaceIndex, Shrinkable<T> shrunkElement) {
        ArrayList<Shrinkable<T>> newElements = new ArrayList<Shrinkable<T>>();
        for (int i = 0; i < this.elements.size(); ++i) {
            if (i == replaceIndex) {
                newElements.add(shrunkElement);
            } else {
                newElements.add(this.elements.get(i));
            }
            if (!this.until.test(this.createValue(newElements))) continue;
            return Optional.of(newElements);
        }
        return Optional.empty();
    }

    public ShrinkingDistance distance() {
        return ShrinkingDistance.forCollection(this.elements);
    }
}

