/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.math.BigInteger;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Stream;
import net.jqwik.api.JqwikException;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.ShrinkingDistance;
import net.jqwik.engine.properties.Range;
import net.jqwik.engine.properties.shrinking.AbstractValueShrinkable;
import net.jqwik.engine.properties.shrinking.BigIntegerGrower;
import net.jqwik.engine.properties.shrinking.BigIntegerShrinker;
import net.jqwik.engine.support.JqwikStreamSupport;

public class ShrinkableBigInteger
extends AbstractValueShrinkable<BigInteger> {
    private final Range<BigInteger> range;
    private final BigInteger shrinkingTarget;

    public ShrinkableBigInteger(BigInteger value, Range<BigInteger> range, BigInteger shrinkingTarget) {
        super(value);
        this.range = range;
        this.shrinkingTarget = shrinkingTarget;
        this.checkValueInRange(value);
    }

    public Stream<Shrinkable<BigInteger>> shrink() {
        return JqwikStreamSupport.concat(this.shrinkTowardsTarget(this), this.shrinkNegativeToPositive(this));
    }

    public Optional<Shrinkable<BigInteger>> grow(Shrinkable<?> before, Shrinkable<?> after) {
        return new BigIntegerGrower().grow((BigInteger)this.value(), this.range, this.shrinkingTarget, before, after);
    }

    public Stream<Shrinkable<BigInteger>> grow() {
        return new BigIntegerGrower().grow((BigInteger)this.value(), this.range, this.shrinkingTarget);
    }

    private Stream<Shrinkable<BigInteger>> shrinkNegativeToPositive(Shrinkable<BigInteger> shrinkable) {
        if (((BigInteger)shrinkable.value()).compareTo(BigInteger.ZERO) >= 0) {
            return Stream.empty();
        }
        return Stream.of(shrinkable).map(s -> ((BigInteger)shrinkable.value()).negate()).filter(this.range::includes).map(this::createShrinkable);
    }

    private Stream<Shrinkable<BigInteger>> shrinkTowardsTarget(Shrinkable<BigInteger> shrinkable) {
        return new BigIntegerShrinker(this.shrinkingTarget).shrink((BigInteger)shrinkable.value()).map(this::createShrinkable).sorted(Comparator.comparing(Shrinkable::distance));
    }

    private Shrinkable<BigInteger> createShrinkable(BigInteger aBigInteger) {
        return new ShrinkableBigInteger(aBigInteger, this.range, this.shrinkingTarget);
    }

    public ShrinkingDistance distance() {
        return ShrinkableBigInteger.distanceFor((BigInteger)this.value(), this.shrinkingTarget);
    }

    static ShrinkingDistance distanceFor(BigInteger value, BigInteger target) {
        BigInteger distance = value.subtract(target).abs();
        if (distance.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) >= 0) {
            return ShrinkingDistance.of((long[])new long[]{Long.MAX_VALUE});
        }
        return ShrinkingDistance.of((long[])new long[]{distance.longValueExact()});
    }

    private void checkValueInRange(BigInteger value) {
        if (!this.range.includes(value)) {
            String message = String.format("Value <%s> is outside allowed range %s", value, this.range);
            throw new JqwikException(message);
        }
    }
}

