/*
 * Decompiled with CFR 0.152.
 */
package net.liftweb.tests;

import net.liftweb.mapper.By$;
import net.liftweb.mapper.BySql;
import net.liftweb.mapper.DB$;
import net.liftweb.mapper.DefaultConnectionIdentifier$;
import net.liftweb.mapper.MaxRows;
import net.liftweb.mapper.OrderBy;
import net.liftweb.mapper.ProtoUser;
import net.liftweb.mapper.ProtoUser$firstName$;
import net.liftweb.mapper.ProtoUser$id$;
import net.liftweb.mapper.QueryParam;
import net.liftweb.mapper.StartAt;
import net.liftweb.tests.User;
import net.liftweb.tests.User$;
import net.liftweb.tests.UserTests$;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.Seq;
import scala.runtime.BoxedObjectArray;
import scala.runtime.BoxesRunTime;
import scala.testing.SUnit;

public class UserTests
extends SUnit.TestCase
implements ScalaObject {
    private final int maxUsers;

    public UserTests() {
        this.maxUsers = 100;
        super("User Tests");
    }

    public void pwdTest() {
        Predef$.MODULE$.intWrapper(1).to(this.maxUsers()).foreach((Function1)new $anonfun$pwdTest$1(this));
    }

    public void countTest() {
        Predef$.MODULE$.assert(User$.MODULE$.count() == (long)this.maxUsers());
        Predef$.MODULE$.assert(User$.MODULE$.count((Seq)new BoxedObjectArray((Object[])new QueryParam[]{By$.MODULE$.apply(User$.MODULE$.email(), "mr33@foo.com", new $anonfun$countTest$1(this))})) == 1L);
        Predef$.MODULE$.assert(User$.MODULE$.count((Seq)new BoxedObjectArray((Object[])new QueryParam[]{By$.MODULE$.apply(User$.MODULE$.email(), "dogmr33@foo.com", new $anonfun$countTest$2(this))})) == 0L);
        Predef$.MODULE$.assert(User$.MODULE$.count((Seq)new BoxedObjectArray((Object[])new QueryParam[]{new BySql("email = ?", (Seq)new BoxedObjectArray(new Object[]{"mr9@foo.com"}))})) == 1L);
        Predef$.MODULE$.assert(User$.MODULE$.count((Seq)new BoxedObjectArray((Object[])new QueryParam[]{new BySql("email = ?", (Seq)new BoxedObjectArray(new Object[]{"eemr1@foo.com"}))})) == 0L);
        Predef$.MODULE$.assert(User$.MODULE$.count((Seq)new BoxedObjectArray((Object[])new QueryParam[]{new BySql("email = ?", (Seq)new BoxedObjectArray(new Object[]{"mr9@foo.com"})), new BySql("firstname = ?", (Seq)new BoxedObjectArray(new Object[]{"9"}))})) == 1L);
        Predef$.MODULE$.assert(User$.MODULE$.count((Seq)new BoxedObjectArray((Object[])new QueryParam[]{new BySql("email = ? AND firstname = ?", (Seq)new BoxedObjectArray(new Object[]{"mr9@foo.com", "9"}))})) == 1L);
        Predef$.MODULE$.assert(User$.MODULE$.count((Seq)new BoxedObjectArray((Object[])new QueryParam[]{new BySql("email = ? AND firstname = ?", (Seq)new BoxedObjectArray(new Object[]{"mr1@foo.com", "33"}))})) == 0L);
        Predef$.MODULE$.assert(User$.MODULE$.count((Seq)new BoxedObjectArray((Object[])new QueryParam[]{new BySql("email = ? AND firstname = ?", (Seq)new BoxedObjectArray(new Object[]{"mr1@foo.com", "1"}))})) == 1L);
        User u = (User)User$.MODULE$.find(BoxesRunTime.boxToInteger((int)33)).open_$bang();
        Predef$.MODULE$.assert(User$.MODULE$.count((Seq)new BoxedObjectArray((Object[])new QueryParam[]{new BySql("email = ?", (Seq)new BoxedObjectArray(new Object[]{u.email()}))})) == 1L);
        Predef$.MODULE$.assert(User$.MODULE$.count((Seq)new BoxedObjectArray((Object[])new QueryParam[]{new BySql("email = ? AND id = ?", (Seq)new BoxedObjectArray(new Object[]{u.email(), u.id()}))})) == 1L);
    }

    public void findAllTest() {
        Predef$.MODULE$.assert(User$.MODULE$.findAll().length() == this.maxUsers(), (Object)("Actual len " + BoxesRunTime.boxToInteger((int)User$.MODULE$.findAll().length()) + " expected " + BoxesRunTime.boxToInteger((int)this.maxUsers())));
        Predef$.MODULE$.assert(User$.MODULE$.findAll((Seq)new BoxedObjectArray((Object[])new QueryParam[]{new MaxRows(25L), new StartAt(25L)})).length() == 25);
        Predef$.MODULE$.assert(User$.MODULE$.findAll((Seq)new BoxedObjectArray((Object[])new QueryParam[]{new StartAt(25L)})).length() == this.maxUsers() - 25);
        Predef$.MODULE$.assert(User$.MODULE$.findAll((Seq)new BoxedObjectArray((Object[])new QueryParam[]{By$.MODULE$.apply(User$.MODULE$.email(), "mr33@foo.com", new $anonfun$findAllTest$1(this))})).length() == 1);
        Predef$.MODULE$.assert(User$.MODULE$.findAll((Seq)new BoxedObjectArray((Object[])new QueryParam[]{By$.MODULE$.apply(User$.MODULE$.email(), "dogmr33@foo.com", new $anonfun$findAllTest$2(this))})).length() == 0);
        Predef$.MODULE$.assert(User$.MODULE$.findAll((Seq)new BoxedObjectArray((Object[])new QueryParam[]{new BySql("email = ?", (Seq)new BoxedObjectArray(new Object[]{"mr9@foo.com"}))})).length() == 1);
        Predef$.MODULE$.assert(User$.MODULE$.findAll((Seq)new BoxedObjectArray((Object[])new QueryParam[]{new BySql("email = ?", (Seq)new BoxedObjectArray(new Object[]{"eemr1@foo.com"}))})).length() == 0);
        Predef$.MODULE$.assert(User$.MODULE$.findAll((Seq)new BoxedObjectArray((Object[])new QueryParam[]{new BySql("email = ?", (Seq)new BoxedObjectArray(new Object[]{"mr9@foo.com"})), new BySql("firstname = ?", (Seq)new BoxedObjectArray(new Object[]{"9"}))})).length() == 1);
        Predef$.MODULE$.assert(User$.MODULE$.findAll((Seq)new BoxedObjectArray((Object[])new QueryParam[]{new BySql("email = ? AND firstname = ?", (Seq)new BoxedObjectArray(new Object[]{"mr9@foo.com", "9"}))})).length() == 1);
        Predef$.MODULE$.assert(User$.MODULE$.findAll((Seq)new BoxedObjectArray((Object[])new QueryParam[]{new BySql("email = ? AND firstname = ?", (Seq)new BoxedObjectArray(new Object[]{"mr1@foo.com", "33"}))})).length() == 0);
        User u = (User)User$.MODULE$.find(BoxesRunTime.boxToInteger((int)33)).open_$bang();
        Predef$.MODULE$.assert(User$.MODULE$.findAll((Seq)new BoxedObjectArray((Object[])new QueryParam[]{new BySql("email = ?", (Seq)new BoxedObjectArray(new Object[]{u.email()}))})).length() == 1);
        ProtoUser$firstName$ protoUser$firstName$ = ((ProtoUser)User$.MODULE$.findAll((Seq)new BoxedObjectArray((Object[])new QueryParam[]{new OrderBy(User$.MODULE$.firstName(), true)})).apply(0)).firstName();
        String string2 = "1";
        Predef$.MODULE$.assert(!(protoUser$firstName$ != null ? !((Object)protoUser$firstName$).equals(string2) : string2 != null));
        ProtoUser$firstName$ protoUser$firstName$2 = ((ProtoUser)User$.MODULE$.findAll((Seq)new BoxedObjectArray((Object[])new QueryParam[]{new OrderBy(User$.MODULE$.firstName(), false)})).apply(0)).firstName();
        string2 = "99";
        Predef$.MODULE$.assert(!(protoUser$firstName$2 != null ? !((Object)protoUser$firstName$2).equals(string2) : string2 != null));
    }

    public void findTest() {
        Predef$.MODULE$.assert(User$.MODULE$.find(BoxesRunTime.boxToInteger((int)1)).isDefined());
        Predef$.MODULE$.assert(User$.MODULE$.find((Seq)new BoxedObjectArray((Object[])new QueryParam[]{By$.MODULE$.apply(User$.MODULE$.email(), "mr9@foo.com", new $anonfun$findTest$1(this))})).isDefined());
        Predef$.MODULE$.assert(!User$.MODULE$.find((Seq)new BoxedObjectArray((Object[])new QueryParam[]{By$.MODULE$.apply(User$.MODULE$.email(), "eemr1@foo.com", new $anonfun$findTest$2(this))})).isDefined());
        Predef$.MODULE$.assert(User$.MODULE$.find(new BySql("email = ?", (Seq)new BoxedObjectArray(new Object[]{"mr9@foo.com"}))).isDefined());
        Predef$.MODULE$.assert(!User$.MODULE$.find(new BySql("email = ?", (Seq)new BoxedObjectArray(new Object[]{"eemr1@foo.com"}))).isDefined());
        Predef$.MODULE$.assert(User$.MODULE$.find((Seq)new BoxedObjectArray((Object[])new QueryParam[]{new BySql("email = ?", (Seq)new BoxedObjectArray(new Object[]{"mr9@foo.com"})), new BySql("firstname = ?", (Seq)new BoxedObjectArray(new Object[]{"9"})), new BySql("firstname = ?", (Seq)new BoxedObjectArray(new Object[]{BoxesRunTime.boxToInteger((int)9)}))})).isDefined());
        Predef$.MODULE$.assert(User$.MODULE$.find(new BySql("email = ? AND firstname = ?", (Seq)new BoxedObjectArray(new Object[]{"mr9@foo.com", "9"}))).isDefined());
        Predef$.MODULE$.assert(!User$.MODULE$.find((Seq)new BoxedObjectArray((Object[])new QueryParam[]{new BySql("email = ? AND firstname = ?", (Seq)new BoxedObjectArray(new Object[]{"mr1@foo.com", "33"}))})).isDefined());
        User u = (User)User$.MODULE$.find(BoxesRunTime.boxToInteger((int)33)).open_$bang();
        ProtoUser$id$ protoUser$id$ = ((ProtoUser)User$.MODULE$.find(new BySql("email = ?", (Seq)new BoxedObjectArray(new Object[]{u.email()}))).open_$bang()).id();
        ProtoUser$id$ protoUser$id$2 = u.id();
        Predef$.MODULE$.assert(!(protoUser$id$ != null ? !((Object)protoUser$id$).equals(protoUser$id$2) : protoUser$id$2 != null));
        ProtoUser$id$ protoUser$id$3 = ((ProtoUser)User$.MODULE$.find(new BySql("id = ?", (Seq)new BoxedObjectArray(new Object[]{BoxesRunTime.boxToInteger((int)33)}))).open_$bang()).id();
        protoUser$id$2 = u.id();
        Predef$.MODULE$.assert(!(protoUser$id$3 != null ? !((Object)protoUser$id$3).equals(protoUser$id$2) : protoUser$id$2 != null));
        ProtoUser$id$ protoUser$id$4 = ((ProtoUser)User$.MODULE$.find(new BySql("id = ?", (Seq)new BoxedObjectArray(new Object[]{u.id()}))).open_$bang()).id();
        protoUser$id$2 = u.id();
        Predef$.MODULE$.assert(!(protoUser$id$4 != null ? !((Object)protoUser$id$4).equals(protoUser$id$2) : protoUser$id$2 != null));
        Predef$.MODULE$.intWrapper(1).to(this.maxUsers()).foreach((Function1)new $anonfun$findTest$3(this));
    }

    public void runTest() {
        this.findTest();
        this.findAllTest();
        this.countTest();
        this.pwdTest();
    }

    public void init() {
        DB$.MODULE$.use(DefaultConnectionIdentifier$.MODULE$, new $anonfun$init$1(this));
    }

    public int maxUsers() {
        return this.maxUsers;
    }
}

