/*
 * Decompiled with CFR 0.152.
 */
package net.liftweb.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import net.liftweb.util.Can;
import net.liftweb.util.Empty$;
import net.liftweb.util.EmptyCan;
import net.liftweb.util.Failure;
import net.liftweb.util.Full;
import net.liftweb.util.Log$;
import net.liftweb.util.TimeHelpers;
import net.liftweb.util.TimeHelpers$;
import scala.;
import scala.Function0;
import scala.List;
import scala.MatchError;
import scala.Nil$;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.StringBuilder;
import scala.Tuple2;
import scala.runtime.BoxesRunTime;

public abstract class TimeHelpers$class {
    public static void $init$(TimeHelpers $this) {
        $this.net$liftweb$util$TimeHelpers$$outer_$eq($this);
        $this.utc_$eq(TimeZone.getTimeZone("UTC"));
        $this.hourFormat_$eq(new SimpleDateFormat("HH:mm:ss"));
    }

    /*
     * WARNING - void declaration
     */
    public static Can toDate(TimeHelpers $this, Object in$1) {
        void var2_2;
        EmptyCan exceptionResult1 = null;
        try {
            Object object = in$1;
            exceptionResult1 = BoxesRunTime.equals((Object)object, null) ? Empty$.MODULE$ : (object instanceof Date ? new Full((Date)object) : (object instanceof Long ? new Full(new Date(BoxesRunTime.unboxToLong((Object)object))) : (object instanceof Number ? new Full(new Date(((Number)object).longValue())) : (BoxesRunTime.equals((Object)Nil$.MODULE$, (Object)object) || BoxesRunTime.equals((Object)Empty$.MODULE$, (Object)object) || BoxesRunTime.equals((Object)None$.MODULE$, (Object)object) || object instanceof Failure ? Empty$.MODULE$ : (object instanceof Full ? $this.toDate(((Full)object).value()) : (object instanceof Some ? $this.toDate(((Some)object).x()) : (object instanceof .colon.colon ? $this.toDate(((.colon.colon)object).hd$1()) : (object instanceof String ? new Full($this.internetDateFormatter().parse((String)object)) : $this.toDate(object.toString())))))))));
        }
        catch (Throwable throwable) {
            Log$.MODULE$.debug(new TimeHelpers$.anonfun.toDate.1($this, in$1), new TimeHelpers$.anonfun.toDate.2($this, throwable));
            exceptionResult1 = new Failure(new StringBuilder().append((Object)"Bad date: ").append(in$1).toString(), new Full(throwable), (List)Nil$.MODULE$);
        }
        return var2_2;
    }

    public static String toInternetDate(TimeHelpers $this, long in) {
        return $this.internetDateFormatter().format(new Date(in));
    }

    public static String toInternetDate(TimeHelpers $this, Date in) {
        return $this.internetDateFormatter().format(in);
    }

    public static Date parseInternetDate(TimeHelpers $this, String dateString$1) {
        return (Date)$this.tryo(new TimeHelpers$.anonfun.parseInternetDate.1($this, dateString$1)).openOr(new TimeHelpers$.anonfun.parseInternetDate.2($this));
    }

    /*
     * WARNING - void declaration
     */
    public static SimpleDateFormat internetDateFormatter(TimeHelpers $this) {
        void var1_1;
        SimpleDateFormat ret = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.US);
        ret.setTimeZone($this.utc());
        return var1_1;
    }

    public static String formattedTimeNow(TimeHelpers $this) {
        return $this.timeFormatter().format($this.now());
    }

    public static String formattedDateNow(TimeHelpers $this) {
        return $this.dateFormatter().format($this.now());
    }

    public static SimpleDateFormat timeFormatter(TimeHelpers $this) {
        return new SimpleDateFormat("HH:mm zzz");
    }

    public static SimpleDateFormat dateFormatter(TimeHelpers $this) {
        return new SimpleDateFormat("yyyy/MM/dd");
    }

    public static String hourFormat(TimeHelpers $this, Date in) {
        return $this.hourFormat().format(in);
    }

    public static Object logTime(TimeHelpers $this, String msg$1, Function0 f2) {
        Tuple2 tuple2 = $this.calcTime(f2);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
        long time$1 = BoxesRunTime.unboxToLong((Object)tuple22._1());
        Object ret = tuple22._2();
        Log$.MODULE$.info(new TimeHelpers$.anonfun.logTime.1($this, msg$1, time$1));
        return ret;
    }

    public static Tuple2 calcTime(TimeHelpers $this, Function0 f2) {
        long start = $this.millis();
        Object result = f2.apply();
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)($this.millis() - start)), result);
    }

    public static long daysSinceEpoch(TimeHelpers $this) {
        return $this.millisToDays($this.millis());
    }

    public static long millisToDays(TimeHelpers $this, long millis) {
        return millis / 86400000L;
    }

    public static int day(TimeHelpers $this, Date in) {
        Calendar cal = Calendar.getInstance($this.utc());
        cal.setTimeInMillis(in.getTime());
        return cal.get(5);
    }

    public static int year(TimeHelpers $this, Date in) {
        Calendar cal = Calendar.getInstance($this.utc());
        cal.setTimeInMillis(in.getTime());
        return cal.get(1);
    }

    public static int month(TimeHelpers $this, Date in) {
        Calendar cal = Calendar.getInstance($this.utc());
        cal.setTimeInMillis(in.getTime());
        return cal.get(2);
    }

    public static Date time(TimeHelpers $this, long when) {
        return new Date(when);
    }

    public static Date dayNow(TimeHelpers $this) {
        return $this.toDateExtension($this.intToTimeSpanBuilder(0).seconds().later()).noTime();
    }

    public static Date timeNow(TimeHelpers $this) {
        return new Date();
    }

    public static int currentYear(TimeHelpers $this) {
        return Calendar.getInstance().get(1);
    }

    public static Calendar today(TimeHelpers $this) {
        return $this.toCalendarExtension(Calendar.getInstance()).noTime();
    }

    public static Date now(TimeHelpers $this) {
        return new Date();
    }

    public static TimeHelpers.CalendarExtension toCalendarExtension(TimeHelpers $this, Calendar c) {
        return new TimeHelpers.CalendarExtension($this, c);
    }

    public static TimeHelpers.DateExtension toDateExtension(TimeHelpers $this, Date d) {
        return new TimeHelpers.DateExtension($this, d);
    }

    public static long weeks(TimeHelpers $this, long in) {
        return $this.days(in) * 7L;
    }

    public static long days(TimeHelpers $this, long in) {
        return $this.hours(in) * 24L;
    }

    public static long hours(TimeHelpers $this, long in) {
        return $this.minutes(in) * 60L;
    }

    public static long minutes(TimeHelpers $this, long in) {
        return $this.seconds(in) * 60L;
    }

    public static long seconds(TimeHelpers $this, long in) {
        return in * 1000L;
    }

    public static long millis(TimeHelpers $this) {
        return System.currentTimeMillis();
    }

    public static long timeSpanToLong(TimeHelpers $this, TimeHelpers.TimeSpan in) {
        return in.millis();
    }

    public static Date timeSpanToDate(TimeHelpers $this, TimeHelpers.TimeSpan in) {
        return in.date();
    }

    public static TimeHelpers.TimeSpan intToTimeSpan(TimeHelpers $this, int in) {
        return $this.TimeSpan().apply(Predef$.MODULE$.int2long(in));
    }

    public static TimeHelpers.TimeSpan longToTimeSpan(TimeHelpers $this, long in) {
        return $this.TimeSpan().apply(in);
    }

    public static TimeHelpers.TimeSpanBuilder intToTimeSpanBuilder(TimeHelpers $this, int in) {
        return new TimeHelpers.TimeSpanBuilder($this, Predef$.MODULE$.int2long(in));
    }

    public static TimeHelpers.TimeSpanBuilder longToTimeSpanBuilder(TimeHelpers $this, long in) {
        return new TimeHelpers.TimeSpanBuilder($this, in);
    }
}

