/*
 * Decompiled with CFR 0.152.
 */
package net.liftweb.sitemap;

import java.io.Serializable;
import net.liftweb.common.Box;
import net.liftweb.common.Box$;
import net.liftweb.common.Full;
import net.liftweb.http.Req;
import net.liftweb.http.S$;
import net.liftweb.sitemap.CompleteMenu;
import net.liftweb.sitemap.ConvertableToMenu;
import net.liftweb.sitemap.HasKids;
import net.liftweb.sitemap.HasKids$class;
import net.liftweb.sitemap.Loc;
import net.liftweb.sitemap.Menu;
import net.liftweb.sitemap.MenuItem;
import net.liftweb.sitemap.SiteMap$;
import net.liftweb.sitemap.SiteMapException;
import net.liftweb.util.Helpers$;
import scala.Either;
import scala.Function1;
import scala.Iterable;
import scala.List;
import scala.Nil$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.ScalaObject;
import scala.Seq;
import scala.StringBuilder;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.runtime.BoxedObjectArray;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiteMap
implements HasKids,
ScalaObject,
Product,
Serializable {
    public volatile int bitmap$0;
    private List<Menu> menus;
    private Set<List<String>> locPath;
    private Map<String, Loc<?>> locs;
    private Seq<Menu> kids;
    private final Seq<ConvertableToMenu> convertablekids;
    private final List<PartialFunction<Box<Req>, Loc.LocParam<Object>>> globalParamFuncs;

    public SiteMap(List<PartialFunction<Box<Req>, Loc.LocParam<Object>>> globalParamFuncs, Seq<ConvertableToMenu> convertablekids) {
        this.globalParamFuncs = globalParamFuncs;
        this.convertablekids = convertablekids;
        HasKids$class.$init$(this);
        Product.class.$init$((Product)this);
        this.locs = Predef$.MODULE$.Map().empty();
        this.locPath = Predef$.MODULE$.Set().apply((Seq)new BoxedObjectArray((Object[])new List[0]));
        this.kids().foreach((Function1)new $anonfun$1(this));
        this.kids().foreach((Function1)new $anonfun$2(this));
        this.kids().foreach((Function1)new $anonfun$3(this));
    }

    private final /* synthetic */ boolean gd1$1(Seq x$1, List x$2) {
        List list = x$2;
        List<PartialFunction<Box<Req>, Loc.LocParam<Object>>> list2 = this.globalParamFuncs();
        return !(list != null ? !list.equals(list2) : list2 != null) && x$1.sameElements((Iterable)this.convertablekids$1());
    }

    public Object productElement(int x$1) {
        List<PartialFunction<Box<Req>, Loc.LocParam<Object>>> list;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                list = this.convertablekids$1();
                break;
            }
            case 0: {
                list = this.globalParamFuncs();
            }
        }
        return list;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "SiteMap";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (!(x$1 instanceof Object)) return false;
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SiteMap)) return false;
        SiteMap siteMap = (SiteMap)object;
        Seq seq = siteMap.convertablekids$1();
        if (seq.lengthCompare(0) < 0) return false;
        if (!this.gd1$1(seq, siteMap.globalParamFuncs())) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public int $tag() {
        return 180697958;
    }

    public /* synthetic */ Seq convertablekids$1() {
        return this.convertablekids;
    }

    public CompleteMenu buildMenu(Box<Loc<?>> current) {
        Box<Loc<?>> box = current;
        List<Loc<?>> path$1 = box instanceof Full ? ((Loc)((Full)box).value()).breadCrumbs() : Nil$.MODULE$;
        return new CompleteMenu((Seq<MenuItem>)this.kids().flatMap((Function1)new $anonfun$buildMenu$1(this, path$1)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Menu> menus() {
        if ((this.bitmap$0 & 4) != 0) return this.menus;
        SiteMap siteMap = this;
        synchronized (siteMap) {
            if ((this.bitmap$0 & 4) == 0) {
                this.menus = this.locs().values().map((Function1)new $anonfun$menus$1(this)).toList();
                this.bitmap$0 |= 4;
            }
            return this.menus;
        }
    }

    public CompleteMenu menuForGroup(String group$2) {
        return new CompleteMenu((Seq<MenuItem>)this.kids().flatMap((Function1)new $anonfun$menuForGroup$1(this, group$2)));
    }

    public Seq<Loc<?>> locForGroup(String group$1) {
        return this.kids().flatMap((Function1)new $anonfun$locForGroup$1(this, group$1)).filter((Function1)new $anonfun$locForGroup$2(this));
    }

    public Box<Loc<?>> findLoc(Req req$1) {
        return Helpers$.MODULE$.first(this.kids(), (Function1)new $anonfun$findLoc$1(this, req$1));
    }

    public Box<Loc<?>> findLoc(String name) {
        return Box$.MODULE$.apply(this.locs().get((Object)name));
    }

    public List<Loc.LocParam<Object>> globalParams() {
        Box<Req> r$1 = S$.MODULE$.request();
        return this.globalParamFuncs().flatMap((Function1)new $anonfun$globalParams$1(this, r$1));
    }

    public void addLoc(Loc<?> in) {
        String name = in.name();
        if (this.locs().isDefinedAt((Object)name)) {
            throw new SiteMapException(new StringBuilder().append((Object)"Location ").append((Object)name).append((Object)" defined twice ").append(this.locs().apply((Object)name)).append((Object)" and ").append(in).toString());
        }
        this.locs_$eq(this.locs().$plus(Helpers$.MODULE$.strToSuperArrowAssoc(name).$minus$greater(in)));
        if (SiteMap$.MODULE$.enforceUniqueLinks() && this.locPath().contains(in.link().uriList())) {
            throw new SiteMapException(new StringBuilder().append((Object)"Location ").append((Object)name).append((Object)" defines a duplicate link ").append(in.link().uriList()).toString());
        }
        this.locPath_$eq((Set<List<String>>)this.locPath().$plus(in.link().uriList()));
    }

    private void locPath_$eq(Set<List<String>> x$1) {
        this.locPath = x$1;
    }

    private Set<List<String>> locPath() {
        return this.locPath;
    }

    private void locs_$eq(Map<String, Loc<?>> x$1) {
        this.locs = x$1;
    }

    private Map<String, Loc<?>> locs() {
        return this.locs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Seq<Menu> kids() {
        if ((this.bitmap$0 & 1) != 0) return this.kids;
        SiteMap siteMap = this;
        synchronized (siteMap) {
            if ((this.bitmap$0 & 1) == 0) {
                this.kids = this.convertablekids().map((Function1)new $anonfun$kids$1(this));
                this.bitmap$0 |= 1;
            }
            return this.kids;
        }
    }

    private Seq<ConvertableToMenu> convertablekids() {
        return this.convertablekids;
    }

    public List<PartialFunction<Box<Req>, Loc.LocParam<Object>>> globalParamFuncs() {
        return this.globalParamFuncs;
    }

    public Either testAccess() {
        return HasKids$class.testAccess(this);
    }

    @Override
    public boolean isRoot_$qmark() {
        return HasKids$class.isRoot_$qmark(this);
    }

    public List buildUpperLines(HasKids x$1, Menu x$2, List x$3) {
        return HasKids$class.buildUpperLines(this, x$1, x$2, x$3);
    }
}

