/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.utils.mail.dkim;

public enum Canonicalization {
    SIMPLE{

        @Override
        public String canonicalizeHeader(String name, String value) {
            return name + ": " + value;
        }

        @Override
        public String canonicalizeBody(String body) {
            if (body == null || "".equals(body)) {
                return "\r\n";
            }
            if (!body.endsWith("\r\n")) {
                return body + "\r\n";
            }
            while (body.endsWith("\r\n\r\n")) {
                body = body.substring(0, body.length() - 2);
            }
            return body;
        }
    }
    ,
    RELAXED{

        @Override
        public String canonicalizeHeader(String name, String value) {
            name = name.trim().toLowerCase();
            value = value.replaceAll("\\s+", " ").trim();
            return name + ":" + value;
        }

        @Override
        public String canonicalizeBody(String body) {
            if (body == null || "".equals(body)) {
                return "\r\n";
            }
            body = body.replaceAll("[ \\t\\x0B\\f]+", " ");
            if (!(body = body.replaceAll(" \r\n", "\r\n")).endsWith("\r\n")) {
                return body + "\r\n";
            }
            while (body.endsWith("\r\n\r\n")) {
                body = body.substring(0, body.length() - 2);
            }
            return body;
        }
    };


    public final String getType() {
        return this.name().toLowerCase();
    }

    public abstract String canonicalizeHeader(String var1, String var2);

    public abstract String canonicalizeBody(String var1);
}

