/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.util;

import java.text.NumberFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.masterthought.cucumber.json.Hook;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public final class Util {
    public static final NumberFormat PERCENT_FORMATTER = NumberFormat.getPercentInstance(Locale.ENGLISH);
    private static final NumberFormat DECIMAL_FORMATTER;
    public static final Util INSTANCE;
    private static final PeriodFormatter TIME_FORMATTER;

    private Util() {
    }

    public static String formatDuration(long duration) {
        return TIME_FORMATTER.print((ReadablePeriod)new Period(0L, duration / 1000000L));
    }

    public static String formatAsPercentage(int value, int total) {
        float average = total == 0 ? 0.0f : 1.0f * (float)value / (float)total;
        return PERCENT_FORMATTER.format(average);
    }

    public static String formatAsDecimal(int value, int total) {
        float average = total == 0 ? 0.0f : 100.0f * (float)value / (float)total;
        return DECIMAL_FORMATTER.format(average);
    }

    public static String toValidFileName(String fileName) {
        return Long.toString((long)fileName.hashCode() + Integer.MAX_VALUE);
    }

    public static List<Hook> eliminateEmptyHooks(Hook[] hooks) {
        return Arrays.asList(hooks).stream().filter(Hook::hasContent).collect(Collectors.toList());
    }

    static {
        PERCENT_FORMATTER.setMinimumFractionDigits(2);
        PERCENT_FORMATTER.setMaximumFractionDigits(2);
        DECIMAL_FORMATTER = NumberFormat.getInstance(Locale.ENGLISH);
        DECIMAL_FORMATTER.setMinimumFractionDigits(2);
        DECIMAL_FORMATTER.setMaximumFractionDigits(2);
        INSTANCE = new Util();
        TIME_FORMATTER = new PeriodFormatterBuilder().appendDays().appendSeparator(" ").appendHours().appendSeparator(":").appendMinutes().appendSeparator(":").printZeroAlways().appendSeconds().appendSeparator(".").minimumPrintedDigits(3).appendMillis().toFormatter();
    }
}

