/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.action.web;

import cn.hutool.core.io.file.FileReader;
import cn.hutool.core.io.file.FileWriter;
import cn.hutool.crypto.SecureUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.entity.BaseEntity;
import net.mingsoft.basic.action.BaseAction;
import net.mingsoft.basic.biz.IAppBiz;
import net.mingsoft.basic.biz.IManagerBiz;
import net.mingsoft.basic.biz.IRoleBiz;
import net.mingsoft.basic.constant.ModelCode;
import net.mingsoft.basic.constant.e.SessionConstEnum;
import net.mingsoft.basic.entity.AppEntity;
import net.mingsoft.basic.entity.ManagerEntity;
import net.mingsoft.basic.entity.ManagerSessionEntity;
import net.mingsoft.basic.entity.RoleEntity;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u767b\u5f55\u7684\u57fa\u7840\u5e94\u7528\u5c42\u63a5\u53e3")
@Controller
@RequestMapping(value={"/${ms.manager.path}"})
public class LoginAction
extends BaseAction {
    @Value(value="${ms.manager.path}")
    private String managerPath;
    @Autowired
    private IManagerBiz managerBiz;
    @Autowired
    private IRoleBiz roleBiz;
    @Autowired
    private IAppBiz appBiz;

    @ApiOperation(value="\u52a0\u8f7d\u7ba1\u7406\u5458\u767b\u5f55\u754c\u9762")
    @GetMapping(value={"/login"})
    public String login(HttpServletRequest request) {
        if (BasicUtil.getSession(SessionConstEnum.MANAGER_SESSION) != null) {
            return "redirect:" + this.managerPath + "/index.do";
        }
        AppEntity app = BasicUtil.getApp();
        if (app != null) {
            if (!StringUtil.isBlank(app.getAppLoginPage())) {
                this.LOG.debug("\u8df3\u8f6c\u81ea\u5b9a\u4e49\u767b\u5f55\u754c\u9762");
                return "redirect:" + app.getAppLoginPage();
            }
        } else {
            String defaultId;
            File file = new File(BasicUtil.getRealPath("WEB-INF/ms.install"));
            if (file.exists() && !StringUtils.isEmpty((CharSequence)(defaultId = FileReader.create((File)new File(BasicUtil.getRealPath("WEB-INF/ms.install"))).readString()))) {
                app = (AppEntity)this.appBiz.getEntity(Integer.parseInt(defaultId));
                app.setAppUrl(this.getUrl(request));
                this.appBiz.updateEntity(app);
                FileWriter.create((File)new File(BasicUtil.getRealPath("WEB-INF/ms.install.bak"))).write(defaultId);
                file.delete();
            }
        }
        request.setAttribute("app", (Object)app);
        return "/login";
    }

    @ApiOperation(value="\u9a8c\u8bc1\u767b\u5f55")
    @ApiImplicitParams(value={@ApiImplicitParam(name="managerName", value="\u5e10\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="managerPassword", value="\u5bc6\u7801", required=true, paramType="query")})
    @PostMapping(value={"/checkLogin"})
    public void checkLogin(@ModelAttribute @ApiIgnore ManagerEntity manager, HttpServletRequest request, HttpServletResponse response) {
        AppEntity urlWebsite = this.appBiz.getByUrl(this.getDomain(request));
        if (urlWebsite == null) {
            this.outJson(response, ModelCode.ADMIN_LOGIN, false, this.getResString("err.not.exist", new String[]{this.getResString("app"), "!\u8bf7\u5c1d\u8bd5\u53bb\u6587\u4ef6 WEB-INF/ms.install.bak \u540e\u7f00bak"}));
            return;
        }
        if (!this.checkRandCode()) {
            this.outJson(response, null, false, this.getResString("err.error", new String[]{this.getResString("rand.code")}));
            return;
        }
        ManagerEntity newManager = new ManagerEntity();
        newManager.setManagerName(manager.getManagerName());
        ManagerEntity _manager = (ManagerEntity)((Object)this.managerBiz.getEntity(newManager));
        if (_manager == null || StringUtils.isEmpty((CharSequence)manager.getManagerName())) {
            this.outJson(response, ModelCode.ADMIN_LOGIN, false, this.getResString("err.nameEmpty"));
        } else if (SecureUtil.md5((String)manager.getManagerPassword()).equals(_manager.getManagerPassword())) {
            ManagerSessionEntity managerSession = new ManagerSessionEntity();
            AppEntity website = new AppEntity();
            RoleEntity role = (RoleEntity)this.roleBiz.getEntity(_manager.getManagerRoleID());
            website = this.appBiz.getByManagerId(role.getRoleManagerId());
            if (website != null && urlWebsite.getAppId() == website.getAppId() && _manager.getManagerRoleID() > 1 || role.getAppId() == this.getAppId(request)) {
                if (website == null) {
                    website = BasicUtil.getApp();
                }
                List<BaseEntity> childManagerList = this.managerBiz.queryAllChildManager(managerSession.getManagerId());
                managerSession.setBasicId(website.getAppId());
                managerSession.setManagerParentID(role.getRoleManagerId());
                managerSession.setManagerChildIDs(childManagerList);
                managerSession.setStyle(website.getAppStyle());
                BasicUtil.setSession(SessionConstEnum.MANAGER_SESSION, (Object)managerSession);
            } else if (_manager.getManagerRoleID() != 1) {
                this.LOG.debug("roleId: " + _manager.getManagerRoleID());
                this.outJson(response, ModelCode.ADMIN_LOGIN, false, this.getResString("err.not.exist", new String[]{this.getResString("manager")}));
            } else {
                BasicUtil.setSession(SessionConstEnum.MANAGER_SESSION, (Object)managerSession);
            }
            BeanUtils.copyProperties((Object)((Object)_manager), (Object)((Object)managerSession));
            Subject subject = SecurityUtils.getSubject();
            UsernamePasswordToken upt = new UsernamePasswordToken(managerSession.getManagerName(), managerSession.getManagerPassword());
            subject.login((AuthenticationToken)upt);
            this.outJson(response, ModelCode.ADMIN_LOGIN, true, null);
        } else {
            this.outJson(response, ModelCode.ADMIN_LOGIN, false, this.getResString("err.password"));
        }
    }
}

