<script type="text/x-template" id="ms-select">
    <el-select v-bind="$props" @change="$emit('change',$event)" v-model="select">
        <el-option v-for='(item,index) in dataList' :key="index" :value="item[dictType?'dictValue':prop.value]"
                   :label="item[dictType?'dictLabel':prop.label]"></el-option>
    </el-select>
</script>
<script>
    (function () {
        var props = Object.assign({
                dictType: String,//字典类型
                url: String,//请求地址
                prop: {
                    type: Object,
                    default:function() {
                        return {
                            value: 'id', //数据值
                            label: 'label'//显示值
                        };
                    }
                }

            },
            Vue.options.components.ElSelect.options.props
        )
        Vue.component('ms-select', {
            template: '#ms-select',
            props: props,
            data: function () {
                return {
                    dataList: [],
                    select: this.value
                }
            },
            watch: {
                select: function (n, o) {
                    this.$emit("input", n)
                },
                value: function (n, o) {
                   this.select = n
                },
            },
            methods: {
                dictList: function () {
                    var that = this;
                    ms.http.get(ms.base + '/mdiy/dict/list.do', {
                        dictType: this.dictType,
                        pageSize: 99999
                    }).then(function (res) {
                        that.dataList = res.rows;
                    }).catch(function (err) {
                        console.log(err);
                    });
                },
                list: function () {
                    var that = this;
                    ms.http.get(this.url, {
                        pageSize: 99999
                    }).then(function (res) {
                        that.dataList = res.data.rows;
                    }).catch(function (err) {
                        console.log(err);
                    });
                },
            },
            created: function () {
                if(this.dictType){//字典类型拉取字典数据
                    this.dictList()
                }else if(this.url){//拉取列表数据
                    this.list()
                }
            }
        });

    })()
</script>



