/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.realm;

import java.util.List;
import net.mingsoft.base.entity.BaseEntity;
import net.mingsoft.basic.biz.IManagerBiz;
import net.mingsoft.basic.biz.IModelBiz;
import net.mingsoft.basic.entity.ManagerEntity;
import net.mingsoft.basic.entity.ModelEntity;
import net.mingsoft.basic.realm.BaseAuthRealm;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.subject.PrincipalCollection;
import org.springframework.beans.factory.annotation.Autowired;

public class ManagerAuthRealm
extends BaseAuthRealm {
    @Autowired
    private IManagerBiz managerBiz;
    @Autowired
    private IModelBiz modelBiz;

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        UsernamePasswordToken upToken = (UsernamePasswordToken)token;
        ManagerEntity newManager = new ManagerEntity();
        newManager.setManagerName(upToken.getUsername());
        ManagerEntity manager = (ManagerEntity)((Object)this.managerBiz.getEntity(newManager));
        if (manager != null) {
            return new SimpleAuthenticationInfo((Object)manager.getManagerName(), (Object)manager.getManagerPassword(), this.getName());
        }
        return null;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principalCollection) {
        String loginName = (String)principalCollection.fromRealm(this.getName()).iterator().next();
        ManagerEntity newManager = new ManagerEntity();
        newManager.setManagerName(loginName);
        ManagerEntity manager = (ManagerEntity)((Object)this.managerBiz.getEntity(newManager));
        if (null == manager) {
            return null;
        }
        SimpleAuthorizationInfo result = new SimpleAuthorizationInfo();
        List<ModelEntity> models = this.modelBiz.queryModelByRoleId(manager.getRoleId());
        for (BaseEntity baseEntity : models) {
            ModelEntity me = (ModelEntity)baseEntity;
            if (StringUtils.isEmpty((CharSequence)me.getModelUrl())) continue;
            result.addStringPermission(me.getModelUrl());
        }
        return result;
    }
}

