/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.action;

import cn.hutool.crypto.SecureUtil;
import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.action.BaseAction;
import net.mingsoft.basic.annotation.LogAnn;
import net.mingsoft.basic.bean.ManagerModifyPwdBean;
import net.mingsoft.basic.biz.IManagerBiz;
import net.mingsoft.basic.biz.IModelBiz;
import net.mingsoft.basic.constant.e.BusinessTypeEnum;
import net.mingsoft.basic.entity.ManagerSessionEntity;
import net.mingsoft.basic.entity.ModelEntity;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u4e3b\u754c\u9762\u63a7\u5236\u5c42")
@Controller
@RequestMapping(value={"/${ms.manager.path}"})
public class MainAction
extends BaseAction {
    @Autowired
    private IModelBiz modelBiz;
    @Autowired
    private IManagerBiz managerBiz;
    @Value(value="${ms.manager.path}")
    private String managerPath;

    @ApiOperation(value="\u52a0\u8f7d\u540e\u53f0\u4e3b\u754c\u9762\uff0c\u5e76\u67e5\u8be2\u6570\u636e")
    @GetMapping(value={"/index", "/"})
    public String index(HttpServletRequest request) {
        ManagerSessionEntity managerSession = this.getManagerBySession();
        List<Object> modelList = new ArrayList();
        ModelEntity model = new ModelEntity();
        modelList = this.modelBiz.queryModelByRoleId(managerSession.getRoleId());
        ArrayList<ModelEntity> _modelList = new ArrayList<ModelEntity>();
        for (int i = 0; i < modelList.size(); ++i) {
            ModelEntity _model = (ModelEntity)((Object)modelList.get(i));
            if (!StringUtils.isBlank((CharSequence)_model.getIsChild())) continue;
            _modelList.add(_model);
        }
        request.setAttribute("managerSession", (Object)managerSession);
        request.setAttribute("modelList", (Object)JSONObject.toJSONString(modelList));
        request.setAttribute("client", (Object)(BasicUtil.getDomain() + "/" + this.managerPath));
        request.setAttribute("app", (Object)BasicUtil.getApp());
        return "/index";
    }

    @GetMapping(value={"/main"})
    public String main(HttpServletRequest request) {
        return "/main";
    }

    @ApiOperation(value="\u67e5\u8be2\u8be5\u7236\u6a21\u5757\u4e0b\u7684\u5b50\u6a21\u5757")
    @ApiImplicitParam(name="modelId", value="\u6a21\u5757\u7f16\u53f7", required=true, paramType="path")
    @GetMapping(value={"/{modelId}/queryListByModelId"})
    @ResponseBody
    public ResultData queryListByModelId(@PathVariable @ApiIgnore int modelId, HttpServletRequest request) {
        HashMap<String, List> modelMap = new HashMap<String, List>();
        List modelList = null;
        ManagerSessionEntity managerSession = this.getManagerBySession();
        ModelEntity model = new ModelEntity();
        if (this.isSystemManager() && modelId == 1) {
            model.setManagerId(1);
            model.setId(String.valueOf(modelId));
            modelList = this.modelBiz.query(model);
        } else if (this.isSystemManager()) {
            model.setModelId(modelId);
            modelList = this.modelBiz.query(model);
        } else {
            modelList = this.modelBiz.queryModelByRoleId(managerSession.getRoleId());
            for (int i = 0; i < modelList.size(); ++i) {
                ModelEntity _model = (ModelEntity)((Object)modelList.get(i));
                if (_model.getModelId() == modelId) continue;
                modelList.remove(i);
                --i;
            }
        }
        modelMap.put("modelList", modelList);
        return ResultData.build().success(modelMap);
    }

    @ApiOperation(value="\u4fee\u6539\u767b\u5f55\u5bc6\u7801")
    @LogAnn(title="\u4fee\u6539\u767b\u5f55\u5bc6\u7801", businessType=BusinessTypeEnum.OTHER)
    @PostMapping(value={"/editPassword"})
    @ResponseBody
    public ResultData editPassword(HttpServletResponse response, HttpServletRequest request) {
        ManagerSessionEntity manager = this.getManagerBySession();
        return ResultData.build().success((Object)manager.getManagerName());
    }

    @ApiOperation(value="\u4fee\u6539\u767b\u5f55\u5bc6\u7801\uff0c\u82e5\u4e0d\u586b\u5199\u5bc6\u7801\u5219\u8868\u793a\u4e0d\u4fee\u6539")
    @ApiImplicitParams(value={@ApiImplicitParam(name="oldManagerPassword", value="\u65e7\u5bc6\u7801", required=true, paramType="query"), @ApiImplicitParam(name="newManagerPassword", value="\u65b0\u5bc6\u7801", required=true, paramType="query")})
    @LogAnn(title="\u4fee\u6539\u767b\u5f55\u5bc6\u7801", businessType=BusinessTypeEnum.UPDATE)
    @PostMapping(value={"/updatePassword"})
    @ResponseBody
    public ResultData updatePassword(@ModelAttribute @ApiIgnore ManagerModifyPwdBean managerModifyPwdBean, HttpServletResponse response, HttpServletRequest request) {
        String oldManagerPassword = managerModifyPwdBean.getOldManagerPassword();
        String newManagerPassword = request.getParameter("newManagerPassword");
        ManagerSessionEntity manager = this.getManagerBySession();
        if (StringUtils.isBlank((CharSequence)newManagerPassword) || StringUtils.isBlank((CharSequence)oldManagerPassword)) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("managerPassword")}));
        }
        if (!oldManagerPassword.equals(manager.getManagerPassword())) {
            return ResultData.build().error(this.getResString("manager.password.old.err"));
        }
        if (!StringUtil.checkLength(newManagerPassword, 6, 30)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("managerPassword"), "6", "30"}));
        }
        manager.setManagerPassword(SecureUtil.md5((String)newManagerPassword));
        this.managerBiz.updateUserPasswordByUserName(manager);
        return ResultData.build().success();
    }

    @ApiOperation(value="\u9000\u51fa\u7cfb\u7edf")
    @GetMapping(value={"/loginOut"})
    @ResponseBody
    public ResultData loginOut(HttpServletRequest request) {
        Subject subject = SecurityUtils.getSubject();
        subject.logout();
        return ResultData.build().success();
    }

    @ApiOperation(value="\u52a0\u8f7dUI\u9875\u9762")
    @GetMapping(value={"/ui"})
    public String ui(HttpServletRequest request) {
        return "/ui";
    }

    @ApiOperation(value="\u52a0\u8f7dUI\u5217\u8868\u754c\u9762")
    @GetMapping(value={"/ui/list"})
    public String list(HttpServletRequest request) {
        return "/ui/list";
    }

    @ApiOperation(value="\u52a0\u8f7dUI\u7684\u8868\u5355\u9875\u9762")
    @GetMapping(value={"/ui/form"})
    public String form(HttpServletRequest request) {
        return "/ui/from";
    }
}

